#!/bin/sh

JBOSS_BIN=$(dirname "$0")

StartService ()
{
  $JBOSS_BIN/run.sh &> /dev/null &
}


StopService ()
{
  $JBOSS_BIN/shutdown.sh -S -u admin -p admin &> /dev/null &
}


StartProcess ()
{
  $JBOSS_BIN/run.sh
}


case $1 in 
  "start")
    StartService
    ;;
    
  "stop")
    StopService
    ;;
    
  "restart")
    StopService
    sleep 5
    StartService
    ;;
  
  "process")
    StartProcess
    ;;
esac
