#!/bin/sh

# Author: jens.ferring@tudor.lu
# Luxembourg, 2011-12-09
# Version 1.5
# !!! THIS IS MAC ONLY !!!

# Warning
echo ""
echo ""
echo ""
echo "**************************************************************"
echo "*                     !!! ATTENTION !!!                      *"
echo "**************************************************************"
echo "*                                                            *"
echo "* 'Clean GECAMed on Mac'-Script v1.6 (2011-12-09)            *"
echo "*                                                            *"
echo "* This is only for Mac OS X.                                 *"
echo "*                                                            *"
echo "* This Script will clean up your GECAMed by deleting your    *"
echo "* GECAMed and PostgreSQL folders. You can use this, to clean *"
echo "* GECAMed before reinstalling it.                            *"
echo "*                                                            *"
echo "* This will also DELETE YOUR DATABASE. If you have any       *"
echo "* important data on your database (not only GECAMed - there  *"
echo "* might be another software using the PostgreSQL database),  *"
echo "* BACKUP YOUR DATABASE FIRST!                                *"
echo "*                                                            *"
echo "* If you want to execute this script please type 'yes' (or   *"
echo "* just 'y') and press enter. Type anything else and press    *"
echo "* enter to cancel the script.                                *"
echo "**************************************************************"
echo ""
echo ""

# Check if the script shall proceed
read -p "Have you read the warning and want to proceed? " PROCEED
echo ""

if [[ !("$PROCEED" == "y" ||  "$PROCEED" == "yes") ]]
then 
	# exited by user
	echo ""
	echo "The folders will NOT be deleted."
	
	exit 1
fi

# try to delete the folders ...
EXIT_CODE=0

# get the GECAMed folder
echo ""
echo "Please enter the folder where you installed GECAMed (enter " 
echo "nothing to choose the default folder '/Applications/GECAMed'). "
echo "You need to replace spaces with '\\ ': "
read -p "/Applications/" FOLDER

if [ "$FOLDER" == "" ]
then
	GECAM_FOLDER="/Applications/GECAMed"
else 
	GECAM_FOLDER="/Applications/$FOLDER"
fi


# --------------------------------
# 	REMOVE JBOSS STARTUP	
# --------------------------------

# remove the JBoss startup
if [ -d "/Library/StartupItems/jboss" ]
then 
	# stop the jboss service
	sudo /Library/StartupItems/jboss/jboss stop
	# wait, so the jboss can shutdown
	sleep 5
	
	# remove the startup folder
	echo "removeing the JBoss startup service ..."
	sudo rm -rf /Library/StartupItems/jboss
	if [ -d "/Library/StartupItems/jboss" ]
	then
		echo "Error: Could NOT remove the JBoss startup service ..."
		EXIT_CODE=1
	else 
		echo "... JBoss startup service removed"
	fi
fi


# ---------------------------------
# 	REMOVE GECAMed FOLDER
# ---------------------------------


if [[ -d "$GECAM_FOLDER" ]]
then 
	
	echo "START DELETING THE FOLDERS"
	echo "..."
	
	# This will clean the whole structure of GECAMed and PostgreSQL, so GECAMed can be reinstalled
	sudo rm -rf "$GECAM_FOLDER/install/"
	sudo rm -rf "$GECAM_FOLDER/java/"
	sudo rm -rf "$GECAM_FOLDER/jboss-4.0.5.GA/"
	sudo rm -rf "$GECAM_FOLDER/scripts/"
	sudo rm -rf "$GECAM_FOLDER/Uninstaller/"
	sudo rm -rf "$GECAM_FOLDER/updater/"
	sudo rm -rf "$GECAM_FOLDER/uninstall.ico"
	sudo rm -rf "$GECAM_FOLDER/icon.ico"
	
	# check if the GECAMed folder is empty
	if [[ ! $(ls $GECAM_FOLDER) ]]
	then 
		# folder is empty and will be deleted
		sudo rm -rf $GECAM_FOLDER
	fi
	
	if [[ -d "$GECAM_FOLDER"
			&&(-d "$GECAM_FOLDER/install/"
			|| -d "$GECAM_FOLDER/java/"
			|| -d "$GECAM_FOLDER/jboss-4.0.5.GA/"
			|| -d "$GECAM_FOLDER/scripts/"
			|| -d "$GECAM_FOLDER/Uninstaller/") ]]
	then
		echo "Error: Could NOT clear the GECAMed folder ..."
		EXIT_CODE=1
	else 
		echo "... GECAMed folder cleared ..."
	fi
else
	# GECAMed cannot be removed, because the folder doesn't exist
	echo "The folder '$GECAM_FOLDER' does NOT exist and therefore"
	echo "cannot be deleted."
fi


# -----------------------------
# 	REMOVE POSTGRESQL	
# -----------------------------


echo ""
echo ""
echo ""
echo "Do you want to remove PostgreSQL as well?" 
read -p "Type 'yes' or just 'y' to proceed: " PROCEED
echo ""


if [[ !("$PROCEED" == "y" ||  "$PROCEED" == "yes") ]]
then 
	# Don't remove PostgreSQL
	echo "PostgreSQL will NOT be removed!"
	echo "DONE"
	
	exit 2
fi


# try to use the uninstaller

PG_LIB_DIR="/Library/PostgreSQL/"

ls "$PG_LIB_DIR" | while IFS= read DIR; do
	if [ -d "$PG_LIB_DIR$DIR" ]
	then
		echo "removing PostgreSQL Version $DIR ..."
		

		# remove the postgres library
		if [ -d "$PG_LIB_DIR$DIR/uninstall-postgresql.app/" ]
		then
			echo "starting PostgreSQL $DIR uninstaller (this may take some minutes) …"
			sudo $PG_LIB_DIR$DIR/uninstall-postgresql.app/Contents/MacOS/installbuilder.sh --mode unattended
			echo "... uninstaller finished"
		fi
		
		# remove postgres application folder if it exists
		if [ -d "/Applications/PostgreSQL $DIR/" ]
		then
			sudo rm -rf "/Applications/PostgreSQL $DIR/"
			if [ -d "/Applications/PostgreSQL $DIR/" ]
			then
				echo "Error: Could NOT remove the PostgreSQL $DIR application folder ..."
				EXIT_CODE=1
			else 
				echo "... PostgreSQL $DIR application folder removed ..."
			fi
		fi
		
		# remove the postgres startup folder if it exists
		if [ -d "/Library/StartupItems/postgresql-$DIR" ]
		then
			sudo rm -rf /Library/StartupItems/postgresql-$DIR
			if [ -d "/Library/StartupItems/postgresql-$DIR" ]
			then
				echo "Error: Could NOT remove the PostgreSQL $DIR startup service ..."
				EXIT_CODE=1
			else
				echo "... PostgreSQL $DIR startup service removed ..."
			fi
		fi
	fi
done


# remove the postgres library
if [ -d "/Library/PostgreSQL" ]
then
	sudo rm -rf /Library/PostgreSQL
	if [ -d "/Library/PostgreSQL" ]
	then
		echo "Error: Could NOT remove the PostgreSQL library ..."
		EXIT_CODE=1
	else 
		echo "... PostgreSQL library removed ..."
	fi
fi



echo ""
if [ $EXIT_CODE > 0 ]
then
	echo "Script ended with some errors"
else
	echo "SUCCESS!"
fi

exit $EXIT_CODE