package lu.tudor.santec.org.fife.ui.autocomplete.dialog;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import lu.tudor.santec.org.fife.ui.autocomplete.AutoCompletionTextComponent;
import lu.tudor.santec.org.fife.ui.autocomplete.IconManager;
import lu.tudor.santec.org.fife.ui.autocomplete.Translator;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author ferring
 * 
 * This dialog provides the option to save a new completion.
 */
public class SaveCompletionDialog extends BaseDialogImpl implements KeyListener
{
	private static final long serialVersionUID = 1L;
	
	protected AutoCompletionTextComponent view;
	
	protected JLabel 		inputTextLabel;
	protected JTextField 	inputTextField;
	protected JLabel		replacementTextLabel;
	protected JTextArea		replacementTextArea;
	

	/**
	 * @param textComponent The text component
	 */
	public SaveCompletionDialog (JFrame owner, AutoCompletionTextComponent textComponent)
	{
		super(owner, 
				Translator.translate(Translator.ADD_COMPLETION), 
				BaseDialog.OK_CANCEL_BUTTON_MODE, 
				new JPanel());
		this.view = textComponent;	
		init();
	}
	
	
	/**
	 * @param textComponent The text component
	 */
	public SaveCompletionDialog (JDialog owner, AutoCompletionTextComponent textComponent)
	{
		super(owner, 
				Translator.translate(Translator.ADD_COMPLETION), 
				BaseDialog.OK_CANCEL_BUTTON_MODE, 
				new JPanel());
		this.view = textComponent;	
		init();
	}
	
	private void init ()
	{
		// initialize components
		inputTextLabel = new JLabel (IconManager.getIcon(IconManager.SHORT_CUT_ICON_NAME));
		inputTextLabel.setToolTipText(Translator.translate("MultiWordAutoCompletion.inputTextToolTip"));
		
		inputTextField = new JTextField();
		inputTextField.addKeyListener(this);
		
		replacementTextLabel = new JLabel(IconManager.getIcon(IconManager.INPUT_TEXT_ICON_NAME));
		replacementTextLabel.setToolTipText(Translator.translate("MultiWordAutoCompletion.replacementTextToolTip"));
		
		replacementTextArea = new JTextArea(view.getSelectedText());
		replacementTextArea.setLineWrap(true);
		replacementTextArea.setWrapStyleWord(true);
		replacementTextArea.addKeyListener(this);
		
		JScrollPane inputTextScroller = new JScrollPane(replacementTextArea);
		
		okAction = new AbstractAction(okButton.getText(), okButton.getIcon())
		{
			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent e)
			{
				saveCompletion ();
				setVisible(false);
			}
		};
		okButton.setAction(okAction);
		enableOkKeyMapping(true);
		enableOkButton();
		
		// initialize panels
		CellConstraints cc = new CellConstraints();
		
		mainPanel.setLayout(new FormLayout(
				"10px, f:p, 5px, f:p:g, 10px", 
				"10px, f:p, 5px, f:100px:g, 10px"));
		
		mainPanel.add(inputTextLabel, 		cc.xy(2, 2));
		mainPanel.add(inputTextField, 		cc.xy(4, 2));
		mainPanel.add(replacementTextLabel, cc.xy(2, 4));
		mainPanel.add(inputTextScroller,	cc.xy(4, 4));
		mainPanel.setOpaque(false);
		
		
		this.pack();
		this.setLocationRelativeTo(view);
	}
	
	
	public void setInputText (String text)
	{
		this.inputTextField.setText(text);
	}
	
	
	public String getInputText ()
	{
		return this.inputTextField.getText();
	}
	
	
	public void setReplacementText (String text)
	{
		this.replacementTextArea.setText(text);
	}
	
	
	public String getReplacementText ()
	{
		return this.replacementTextArea.getText();
	}
	
	
	/**
	 * Saves a new completion with the given input and replacement text.
	 */
	protected void saveCompletion ()
	{
		String replacementText 	= replacementTextArea.getText();
		String shortCutText 	= inputTextField.getText().trim();
		
		if ("".equals(replacementText))
			return;
		
		if ("".equals(shortCutText))
			view.addCompletion(replacementText);
		else
			view.addCompletion(shortCutText, replacementText);
	}
	
	
	/**
	 * Enables the OK button, so it can be clicked.
	 */
	protected void enableOkButton ()
	{
		okButton.setEnabled(!replacementTextArea.getText().equals(""));
	}
	
	/* (non-Javadoc)
	 * @see java.awt.event.KeyListener#keyReleased(java.awt.event.KeyEvent)
	 */
	public void keyReleased(KeyEvent e)
	{
		enableOkButton();
	}


	public void keyTyped(KeyEvent e) {}
	public void keyPressed(KeyEvent e) {}
}
