package lu.tudor.santec.org.fife.ui.autocomplete;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class Translator
{
	public static final String HOTKEYS 						= "MultiWordAutoCompletion.hotkeys";
	public static final String ADD_COMPLETION 				= "MultiWordAutoCompletion.addCompletion";
	public static final String ADD_SELECTED_TEXT 			= "MultiWordAutoCompletion.addSelectedText";
	public static final String CANCEL 						= "MultiWordAutoCompletion.cancel";
	public static final String CLOSE 						= "MultiWordAutoCompletion.close";
	public static final String EDIT_COMPLETIONS 			= "MultiWordAutoCompletion.editCompletions";
	public static final String INPUT_TEXT_TOOL_TIP 			= "MultiWordAutoCompletion.inputTextToolTip";
	public static final String NO 							= "MultiWordAutoCompletion.no";
	public static final String OK 							= "MultiWordAutoCompletion.ok";
	public static final String REPLACEMENT_TEXT_TOOL_TIP 	= "MultiWordAutoCompletion.replacementTextToolTip";
	public static final String SAVE_COMPLETION 				= "MultiWordAutoCompletion.saveCompletion";
	public static final String YES 							= "MultiWordAutoCompletion.yes";
	// hot key descriptions
	public static final String QUICK_ADD_HOTKEY				= "MultiWordAutoCompletion.addSelectedTextHotKeyDescription";
	public static final String SAVE_COMPLETION_HOTKEY		= "MultiWordAutoCompletion.saveCompletionHotKeyDescription";
	public static final String EDIT_COMPLETION_HOTKEY		= "MultiWordAutoCompletion.editCompletionsHotKeyDescription";
	public static final String START_AUTO_COMPLETION_HOTKEY	= "MultiWordAutoCompletion.startAutoCompletionHotKeyDescription";
	public static final String COMPLETE_UNAMBIGUOUSLY_HOTKEY= "MultiWordAutoCompletion.completeUnambiguouslyHotKeyDescription";
	
	
	
	private static final String BUNDLE_NAME					= ".resources.translations";
	
	private static Map<String, String> translatrix;
	
	
	static 
	{
		// set defaults:
		translatrix = new HashMap<String, String>();
		StringBuffer bundlePath = new StringBuffer(Translator.class.getPackage().getName())
				.append(BUNDLE_NAME);
		ResourceBundle bundle = ResourceBundle.getBundle(bundlePath.toString());
		Enumeration<String> keys = bundle.getKeys();
		String key;
		
		while (keys.hasMoreElements())
		{
			key = keys.nextElement();
			translatrix.put(key, bundle.getString(key));
		}
	}
	
	public static String translate (String key)
	{
		String translation = translatrix.get(key);
		try {
			return translation != null ? translation : key.split(".")[1];
		} catch (Exception e)
		{
			return key;
		}
	}
	
	public String t (String key)
	{
		return translate(key);
	}
	
	public static void setTranslations (Map<String, String> translations)
	{
		Set<String> keys = translations.keySet();
		
		for (String key : keys)
		{
			if (translatrix.containsKey(key))
				translatrix.put(key, translations.get(key));
		}
	}
	
	public static void setTranslation (String key, String translation)
	{
		if (translatrix.containsKey(key))
			translatrix.put(key, translation);
	}
}
