package lu.tudor.santec.org.fife.ui.autocomplete;

/**
 * @author ferring
 * 
 * This class is the implementation of the Completion interface 
 * used by the MWAutoCompletion
 */
public class MultiWordCompletion extends AbstractCompletion
{
	/* ======================================== */
	// 		PRIVATE MEMBERS
	/* ======================================== */
	
	private String inputText;
	private String replacementText;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	/**
	 * @param provider The provider that contains this completion
	 * @param replacementText The text that will be inserted
	 */
	public MultiWordCompletion (CompletionProvider provider, String replacementText)
	{
		this (provider, null, replacementText);
	}
	
	/**
	 * @param provider The provider that contains this completion
	 * @param inputText The text that will be shown in the menu, but not be entered
	 * @param replacementText The text that will be inserted
	 */
	public MultiWordCompletion (CompletionProvider provider, String inputText,
			String replacementText)
	{
		super(provider);
		this.setReplacementText(replacementText);
		this.setInputText(inputText);
	}
	
	
	
	/* ======================================== */
	// 		GETTER & SETTER
	/* ======================================== */

	/* (non-Javadoc)
	 * @see lu.tudor.santec.org.fife.ui.autocomplete.Completion#getReplacementText()
	 */
	public String getReplacementText()
	{
		return replacementText;
	}
	
	/**
	 * @param text The new replacement text that will be inserted
	 */
	public void setReplacementText (String text)
	{
		if (text == null)
			throw new NullPointerException("The replacement text must not be null!");
		
		this.replacementText = text;
	}
	
	/* (non-Javadoc)
	 * @see lu.tudor.santec.org.fife.ui.autocomplete.AbstractCompletion#getInputText()
	 */
	public String getInputText ()
	{
		return inputText == null ? replacementText : inputText;
	}
	
	/**
	 * @param text The new input text, that will be shown, but not necessarily be inserted
	 */
	public void setInputText (String text)
	{
		this.inputText = text;
	}
	
	/**
	 * @return <code>true</code> if the the input text is set, 
	 * <code>false</code> if it is null and the replacement 
	 * text will be returned instead
	 */
	public boolean isInputTextSet ()
	{
		return 	   inputText != null 
				// no, really != and not !equal() ...
				&& inputText != replacementText;
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.org.fife.ui.autocomplete.Completion#getSummary()
	 */
	public String getSummary()
	{
		return null;
	}
	
	/* (non-Javadoc)
	 * @see lu.tudor.santec.org.fife.ui.autocomplete.AbstractCompletion#getToolTipText()
	 */
	@Override
	public String getToolTipText()
	{
		return getReplacementText();
	}
	
	/* (non-Javadoc)
	 * @see lu.tudor.santec.org.fife.ui.autocomplete.AbstractCompletion#toString()
	 */
	@Override
	public String toString()
	{
		return isInputTextSet() ? inputText + " - " + replacementText : replacementText;
	}
}
