package lu.tudor.santec.org.fife.ui.autocomplete;

import java.io.Serializable;

import javax.swing.KeyStroke;

/**
 * @author ferring
 * 
 * This event is used by the <code>MWHotKeyListener</code>
 */
public class MWHKEvent implements Serializable
{
	private static final long 			serialVersionUID = 1L;
	
	// the codes for the actions:
	public static final int 			QUICK_ADD_ACTION 			= 0;
	public static final int 			SAVE_COMPLETION_ACTION 		= 1;
	public static final int 			EDIT_COMPLETION_ACTION 		= 2;
	public static final int 			START_AUTOCOMPLETION_ACTION = 3;
	public static final int 			AUTO_FILL_ACTION 			= 4;
	
	
	private AutoCompletionTextComponent source;
	private long 						when;
	private KeyStroke					oldHotKey;
	private KeyStroke					newHotKey;
	private int 						actionForHotKey;
	
	
	/**
	 * @param source The completion provider
	 * @param when The time in milliseconds that specifies, when the event happened 
	 * @param oldHotKey The old hot key that is to be replaced
	 * @param newHotKey The new hot key that is to replace the old hot key
	 * @param actionForHotKey The code for the action of the hot key
	 */
	public MWHKEvent(AutoCompletionTextComponent source, long when,
			KeyStroke oldHotKey, KeyStroke newHotKey, int actionForHotKey)
	{
		this.source 		= source;
		this.when 			= when;
		this.oldHotKey 		= oldHotKey;
		this.newHotKey 		= newHotKey;
		this.actionForHotKey= actionForHotKey;
	}


	/**
	 * @return The completion provider
	 */
	public AutoCompletionTextComponent getSource()
	{
		return source;
	}

	/**
	 * @return The time in milliseconds that specifies, when the event happened 
	 */
	public long getWhen()
	{
		return when;
	}

	/**
	 * @return The old hot key that is to be replaced
	 */
	public KeyStroke getOldHotKey()
	{
		return oldHotKey;
	}

	/**
	 * @returnThe new hot key that is to replace the old hot key
	 */
	public KeyStroke getNewHotKey()
	{
		return newHotKey;
	}

	/**
	 * @return The code for the action of the hot key
	 */
	public int getActionForHotKey()
	{
		return actionForHotKey;
	}
}
