package lu.tudor.santec.org.fife.ui.autocomplete;

import java.awt.Window;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

/**
 * @author ferring
 * 
 * Overrides the AutoCompletePopupWindow to implement some function, 
 * needed by the multi word auto completion. 
 */
public class MWACPopupWindow extends AutoCompletePopupWindow
{
	private static final long serialVersionUID = 1L;
	
	private MWAutoCompletion ac;
	
	/**
	 * @param parent The window, that contains the AutoCompletionTextComponent 
	 * @param ac The MWAutoCompletion
	 */
	public MWACPopupWindow(Window parent, MWAutoCompletion ac)
	{
		super(parent, ac);
		this.ac = ac;
	}
	
	@Override
	protected void createKeyActionPairs()
	{
		super.createKeyActionPairs();
		tabKap.action = new AbstractAction()
		{
			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent e)
			{
				ac.autoAddLettersWhereObvious();
			}
		};
	}
}
