package lu.tudor.santec.org.fife.ui.autocomplete;


/**
 * @author ferring
 * 
 * Called whenever a completion was added, removed, changed or a provider is initialized.
 */
public interface MWACListener
{
	/**
	 * @param event A new completion was added.
	 */
	public void completionAdded (MWACEvent event);
	
	/**
	 * @param event A completion was removed.
	 */
	public void completionRemoved (MWACEvent event);
	
	/**
	 * @param event An existing completion was changed.
	 */
	public void completionChanged (MWACEvent event);
	
	/**
	 * @param event A new provider needs to be initialized.
	 */
	public void initializeCompletion (MWACEvent event);
	
//	/**
//	 * @param event The context of this provider was changed
//	 */
//	public void contextChanged (MWACEvent event);
	
	/**
	 * This method is supposed to assign the same provider to 
	 * text components with the same context.
	 * 
	 * @param context The context of the provider.
	 * @return The found provider.
	 */
	public MWCompletionProvider getProviderByContext (String context);
}
