package lu.tudor.santec.org.fife.ui.autocomplete;

import java.awt.Window;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.text.DefaultHighlighter;

import lu.tudor.santec.org.fife.ui.autocomplete.dialog.BaseDialogImpl;
import lu.tudor.santec.org.fife.ui.autocomplete.dialog.EditCompletionDialog;
import lu.tudor.santec.org.fife.ui.autocomplete.dialog.SaveCompletionDialog;


/**
 * @author ferring
 * 
 * This handler handles incoming events of the <code>MWACHotKeyHandler</code> 
 * and the the <code>MWACMenuHandler</code>.
 */
public class MWACHandler
{
	protected AutoCompletionTextComponent view;
	
	
	/**
	 * @param view the AutoCompletionTextComponent, the events this handler handles.
	 */
	public MWACHandler(AutoCompletionTextComponent view)
	{
		init(view);
	}
	
	
	protected void init (AutoCompletionTextComponent view)
	{
		this.view = view;
		
		view.getTextComponent().setHighlighter(new DefaultHighlighter());
	}



	/**
	 * Shows the save completion dialog
	 */
	public void showSaveCompletionDialog ()
	{
		Window owner = BaseDialogImpl.getParentWindow(view);
		if (owner instanceof JDialog)
			new SaveCompletionDialog((JDialog)owner, view).setVisible(true);
		else
			new SaveCompletionDialog((JFrame)owner, view).setVisible(true);
	}
	
	
	/**
	 * Show the edit completion dialog
	 */
	public void showEditCompletionDialog ()
	{
		Window owner = BaseDialogImpl.getParentWindow(view);
		if (owner instanceof JDialog)
			new EditCompletionDialog((JDialog)owner, view).setVisible(true);
		else
			new EditCompletionDialog((JFrame)owner, view).setVisible(true);
	}
	
	
	/**
	 * Adds the selected text as new completion to the provider of the text component
	 */
	public void quickAdd ()
	{
		if (view == null || view.getSelectedText() == null)
			// if there is no text component set or no text selected, no text can be added
			return;
		
		String replacementText = view.getSelectedText();
		
		if (!"".equals(replacementText))
			if (view.addCompletion(replacementText))
				view.highlightSelectedText(AutoCompletionTextComponent.SUCCESS_HIGHLIGHTING_COLOR, 
						AutoCompletionTextComponent.DEFAULT_HIGHLIGHTING_TIME);
			else
				view.highlightSelectedText(AutoCompletionTextComponent.FAILED_HIGHLIGHTING_COLOR, 
						AutoCompletionTextComponent.DEFAULT_HIGHLIGHTING_TIME);
	}
}
