package lu.tudor.santec.numberwriter;
/*******************************************************************************
 *                                                                            
 *   Copyright (c) 2004, 2007 by CRP Henri TUDOR - SANTEC LUXEMBOURG 
 *   check http://santec.tudor.lu for more information
 * 
 *   Contributor(s):                         
 *    Johannes Hermen  johannes.hermen(at)tudor.lu                                                   
 *                                                                            
 *   This library is free software; you can redistribute it and/or modify it  
 *   under the terms of the GNU Lesser General Public License (version 2.1)
 *   as published by the Free Software Foundation.
 *                                                                            
 *   This software is distributed in the hope that it will be useful, but     
 *   WITHOUT ANY WARRANTY; without even the implied warranty of               
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        
 *   Lesser General Public License for more details.                          
 *                                                                            
 *   You should have received a copy of the GNU Lesser General Public         
 *   License along with this library; if not, write to the Free Software      
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  
 *                                                                            
 *     
 *******************************************************************************/
public class FrenchNumberWriter {

	private static final String[] EINER = { 
		          "zéro", "un", "deux", "trois", "quatre", "cinq",
		          "six", "sept", "huit", "neuf", "dix",
		          "onze", "douze", "treize", "quatorze",
		          "quinze", "seize", "dix-sept",
		          "dix-huit", "dix-neuf" };

	private static final String[] ZEHNER = { 
		"", "", "vingt", "trente", "quarante", "cinquante",
	      "soixante", "soixante-dix", "quatre-vingt", "quatre-vingt-dix" };
	
	private static final String[] POTENZEN = { 
		"cent", "mille", "million"};


	public static String writeNumber(int number) {
		if (number == 0)
			return EINER[0];
		else if (number == 1)
			return EINER[1];
		else {
			StringBuffer buf = new StringBuffer();
			lessTrillion(buf, number);
			return buf.toString();
		}
	}

	private static void less100(StringBuffer buf, int number) {
		// less than 20
		if (number < 20)
			buf.append(EINER[number]);
		// 71 - 79
		else if (number > 70 && number < 80) {
			buf.append(ZEHNER[6] + "-" + EINER[(number % 10)+10]);
		}
		// 80
		else if (number == 80) 
			buf.append(ZEHNER[8] + "s");
		//91 - 99
		else if (number > 90 && number < 100) {
			buf.append(ZEHNER[8] + "-" + EINER[(number % 10)+10]);
		}
		else if (number % 10 == 0) 
			buf.append(ZEHNER[number / 10]);
		else if (number % 10 == 1) 
			buf.append(ZEHNER[number / 10] + " et " + EINER[1]);
		else {
			buf.append(ZEHNER[number / 10] + "-" + EINER[number % 10]);
		}
	}

	private static void less1000(StringBuffer buf, int number) {
		if (number < 100) {
			less100(buf, number);
		} else if (number == 100) { 
			buf.append(POTENZEN[0]);
		} else if (number / 100 == 1) {
			buf.append(POTENZEN[0] + " ");
			less100(buf, number % 100);
		} else if (number % 100 == 0) {
			buf.append(EINER[number / 100] + " ");
			buf.append(POTENZEN[0] + "s ");
		} else {
			buf.append(EINER[number / 100] + " ");
			buf.append(POTENZEN[0]+"s  ");
			less100(buf, number % 100);
		}
	}

	private static void lessMillion(StringBuffer buf, int number) {
		if (number < 1000) {
			less1000(buf, number);
		} else if (number < 2000) {
			buf.append(EINER[1] +" " + POTENZEN[1]+" ");
			less1000(buf, number % 1000);
		} else {
			less1000(buf, number / 1000);
			buf.append(" "+POTENZEN[1]+" ");
			less1000(buf, number % 1000);
		}
	}
	
	private static void lessTrillion(StringBuffer buf, int number) {
		if (number<0) {
			buf.append("moins ");
			number = -number;
		}
		
		if (number < 1000000) {
			lessMillion(buf, number);
		} else if (number < 2000000) {
			buf.append(EINER[1]+ POTENZEN[2]+" ");
			lessMillion(buf, number % 1000000);
		} else {
			lessMillion(buf, number / 1000000);
			buf.append(" "+ POTENZEN[2]+" ");
			lessMillion(buf, number % 1000000);
		}
	}
}
