/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.waitingroom.gui;

import java.awt.BorderLayout;

import javax.swing.JCheckBox;
import javax.swing.JPanel;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.SettingsPlugin;

/**
 * Settingsplugin for user settings of the waitingroom module.
 * 
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: WaitingroomSettingsPlugin.java,v $
 * <br>Revision 1.5  2013-12-27 18:09:24  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.4  2013-08-21 12:52:09  troth
 * <br>Fix Bug: if the users switch between show all and one waitingroom there was send a message to all users to refresh the waitingrooms and that two time this is not needed.
 * <br>
 * <br>Revision 1.3  2010-12-21 15:58:11  troth
 * <br>add java doc
 * <br>
 * <br>Revision 1.2  2010-12-21 14:49:11  troth
 * <br>fixed Ticket #649 add additional attitude
 * <br>
 * <br>Revision 1.1  2010-12-20 15:42:05  troth
 * <br>GUI redesign of Waitingroom and the Waitingroom get his own usersettingpanel
 * <br>
 */
public class WaitingroomSettingsPlugin extends SettingsPlugin {
	
	private static final long serialVersionUID = 1L;

	public static final String NAME 			= "waitingroomModuleSettings";
	
	/**
	 * show all/only current physician waitingroom
	 */
	public static final String SHOW_ALL_WAITINGROOMS_ENABLED = "SHOW_ALL_WAITINGROOMS_ENABLED";
	
	private JPanel showAllWaitingroomsPanel;
	
	private JCheckBox showAllWaitingroomsCheckBox;

	/**
	 * 
	 */
	public WaitingroomSettingsPlugin() {
		super(NAME);
		this.setStationaryValues();
		buildPanel();
	}

	/**
	 * @param p_Name
	 */
	public WaitingroomSettingsPlugin(String p_Name) {
		super(p_Name);
		this.setStationaryValues();
		buildPanel();
	}

	/**
	 * Build the GUI of the setting panel
	 */
	private void buildPanel() {

		setLabel(Translatrix.getTranslationString("waitingroom"));
		
		// #####################################################
		// option show all/only current Physician waiting room
		this.showAllWaitingroomsPanel = createSubPanel(Translatrix.getTranslationString("waitingroom"));
		this.showAllWaitingroomsPanel.setLayout(new BorderLayout());
		this.showAllWaitingroomsCheckBox = new JCheckBox(Translatrix.getTranslationString("waitingroom.showAllWaitingroomsText"));
//		this.showAllWaitingroomsCheckBox.addActionListener(new ActionListener() {
//			public void actionPerformed(ActionEvent e) {
//				
//				setValueAndSave(SHOW_ALL_WAITINGROOMS_ENABLED, (Boolean) showAllWaitingroomsCheckBox.isSelected());
//				WaitingroomModule.getInstance().setShowRoomButton();
//				
//				WaitingroomManager manager = (WaitingroomManager) ManagerFactory.getRemote(WaitingroomManagerBean.class);
//				
//				try {
//					manager.sendRoomUpdateMessage();
//				} catch (JMSException e1) {
//					e1.printStackTrace();
//				}
//			}
//		});
		
		this.showAllWaitingroomsPanel.add(this.showAllWaitingroomsCheckBox,BorderLayout.WEST);
		
		addSubPanel(this.showAllWaitingroomsPanel);
		// #####################################################
		
		relocalize();
		
		setIcon(WaitingroomModule.getScaledIcon(WaitingroomModule.WAITINGROOM_ICON, WaitingroomModule.NORMALPIX));//getIcon(WaitingroomModule.WAITINGROOM_ICON));
		//setIcon(WaitingroomModule.getIcon(WaitingroomModule.WAITINGROOM_ICON));
	}

	public void revertToDefaults() {
		this.showAllWaitingroomsCheckBox.setSelected((Boolean) getDefault(SHOW_ALL_WAITINGROOMS_ENABLED));
		reflectSettings();
		super.revertToDefaults();
	}
	

	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#updateSettings()
	 */
	public void updateSettings() {
		setValue(SHOW_ALL_WAITINGROOMS_ENABLED, (Boolean) this.showAllWaitingroomsCheckBox.isSelected());
				
		super.updateSettings();

		WaitingroomModule.getInstance().setShowRoomButton();
		
		// TODO old code - do not send a message refresh waitingroom to all users
//		WaitingroomManager manager = (WaitingroomManager) ManagerFactory.getRemote(WaitingroomManagerBean.class);
//		try {
//			manager.sendRoomUpdateMessage();
//		} catch (JMSException e1) {
//			e1.printStackTrace();
//		}
	}

	
	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#reflectSettings()
	 */
	public void reflectSettings() {
		super.reflectSettings();
		this.showAllWaitingroomsCheckBox.setSelected((Boolean) getValue(SHOW_ALL_WAITINGROOMS_ENABLED));
	}

	
	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#relocalize()
	 */
	public void relocalize() {
		super.relocalize();
		setLabel(Translatrix.getTranslationString("waitingroom"));
		this.showAllWaitingroomsCheckBox.setText(Translatrix.getTranslationString("waitingroom.showAllWaitingroomsText"));
	}

	/**
	 * 
	 */
	public void setStationaryValues() {
		setStationary(SHOW_ALL_WAITINGROOMS_ENABLED, true);
	}

	/**
	 * Set/save a key and boolean value
	 * 
	 * @param key
	 * @param value
	 */
	public void setValueAndSave(String key, Object value)
	{
		setValue(key, (Boolean) value);
		reflectSettings();
		updateSettings();
		MainFrame.getInstance().saveSettings();
	}
}