package lu.tudor.santec.gecamed.waitingroom.ejb.session.util;

import java.io.Serializable;

import lu.tudor.santec.gecamed.waitingroom.ejb.entity.beans.Queue;

public class QueueUpdateEvent implements Serializable{

    private static final long serialVersionUID = 1L;

    public static final Integer ENTRY_ADD = 0;
    public static final Integer ENTRY_DELETE = 1;
    public static final Integer ENTRY_UPDATE = 2;
    
    public static final String[] STATUSNAMES = {
	"ADD",
	"DELETE",
	"UPDATE"
    };
    
    private String clientId;
    private Integer roomId;
    private Integer status;
    private Queue entry;
    
    public QueueUpdateEvent(String clientId, Integer roomId, Integer status, Queue entry) {
	this.clientId = clientId;
	this.roomId = roomId;
	this.status = status;
	this.entry = entry;
	
    }
    
    
    /**
     * @return the clientId
     */
    public String getClientId() {
        return clientId;
    }
    /**
     * @param clientId the clientId to set
     */
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }
    /**
     * @return the roomId
     */
    public Integer getRoomId() {
        return roomId;
    }
    /**
     * @param roomId the roomId to set
     */
    public void setRoomId(Integer roomId) {
        this.roomId = roomId;
    }
    /**
     * @return the status
     */
    public Integer getStatus() {
        return status;
    }
    /**
     * @param status the status to set
     */
    public void setStatus(Integer status) {
        this.status = status;
    }
    /**
     * @return the entry
     */
    public Queue getEntry() {
        return entry;
    }
    /**
     * @param entry the entry to set
     */
    public void setEntry(Queue entry) {
        this.entry = entry;
    }
    
    
    
    
    public String toString() {
	return "Room " + getRoomId() + " " + STATUSNAMES[getStatus()] + " "+ entry;
    }
    
}
