/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: WaitingroomManager.java,v $
 * <br>Revision 1.11  2012-10-03 12:24:33  troth
 * <br>Implement ticket #1000.
 * <br>
 * <br>Revision 1.10  2011-10-28 15:11:02  troth
 * <br>fix Ticket #900: Recurrence Appointments are not show in the Waitingroom.
 * <br>
 * <br>Revision 1.9  2010-05-12 09:00:15  hermen
 * <br>changed handling and fetching of room-updates.
 * <br>collectAppointments is now called each 5 min by server,
 * <br>rooms are updated by single entry, not by full reload as before.
 * <br>
 * <br>Revision 1.8  2010-04-30 13:08:42  hermen
 * <br>added site to waitingroom
 * <br>
 * <br>Revision 1.7  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.6  2008-07-04 13:02:04  heinemann
 * <br>complete - # 159: Add notes to entries of the waitingroom
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/159
 * <br>
 * <br>Revision 1.5  2008-05-08 09:10:02  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2008-05-07 14:39:53  heinemann
 * <br>new waitingroom
 * <br>
 * <br>Revision 1.3  2008-04-29 14:17:38  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2008-02-27 08:26:48  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2008-02-11 16:47:53  heinemann
 * <br>Initial checkin
 * <br>
 *   
 */
package lu.tudor.santec.gecamed.waitingroom.ejb.session.interfaces;

import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.annotation.security.RolesAllowed;
import javax.ejb.Remote;
import javax.jms.JMSException;

import lu.tudor.santec.gecamed.waitingroom.ejb.entity.beans.Queue;
import lu.tudor.santec.gecamed.waitingroom.ejb.entity.beans.Reason;
import lu.tudor.santec.gecamed.waitingroom.ejb.entity.beans.Room;
import lu.tudor.santec.gecamed.waitingroom.ejb.session.util.QueueUpdateEvent;

/**
 * Remote interface of the waitingroom session bean
 * 
 * @author martin.heinemann@tudor.lu
 * 23.01.2008
 * 15:59:36
 *
 *
 * @version
 * <br>$Log: WaitingroomManager.java,v $
 * <br>Revision 1.11  2012-10-03 12:24:33  troth
 * <br>Implement ticket #1000.
 * <br>
 * <br>Revision 1.10  2011-10-28 15:11:02  troth
 * <br>fix Ticket #900: Recurrence Appointments are not show in the Waitingroom.
 * <br>
 * <br>Revision 1.9  2010-05-12 09:00:15  hermen
 * <br>changed handling and fetching of room-updates.
 * <br>collectAppointments is now called each 5 min by server,
 * <br>rooms are updated by single entry, not by full reload as before.
 * <br>
 * <br>Revision 1.8  2010-04-30 13:08:42  hermen
 * <br>added site to waitingroom
 * <br>
 * <br>Revision 1.7  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.6  2008-07-04 13:02:04  heinemann
 * <br>complete - # 159: Add notes to entries of the waitingroom
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/159
 * <br>
 * <br>Revision 1.5  2008-05-08 09:10:02  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2008-05-07 14:39:53  heinemann
 * <br>new waitingroom
 * <br>
 * <br>Revision 1.3  2008-04-29 14:17:38  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2008-02-27 08:26:48  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2008-02-11 16:47:53  heinemann
 * <br>Initial checkin
 * <br>
 *   
 */

@Remote
@RolesAllowed("gecam")
public interface WaitingroomManager {

	
	
	
	/**
	 * Topic for waitingroom updates
	 */
	public static final String TOPIC_NAME = "topic/GECAMed/waitingroomUpdateTopic";
	
	public static final String TOPIC_CMD_ROOM_UPDATE = "updateRooms";
	
	/**
	 * Save a room in the database.
	 * 
	 * @param room
	 * @return the persisted room
	 */
	@RolesAllowed("gecam")
	public Room saveRoom(Room room, String clientId);
	
	
	/**
	 * Delete the given room. 
	 * 
	 * @param room
	 * @return true if everything is fine
	 */
	@RolesAllowed("gecam")
	public boolean deleteRoom(Room room);
	
	
	/**
	 * Returns all rooms available in the database
	 * ordered by orderId
	 * @return
	 */
	@RolesAllowed("gecam")
	public List<Room> getAllRooms();
	
	/**
	 * Saves a queue object
	 * 
	 * @param queue
	 * @return
	 */
	@RolesAllowed("gecam")
	public Queue saveQueue(Queue queue, String clientId, Integer oldRoom);
	
	/**
	 * @param queue
	 */
	@RolesAllowed("gecamed")
	public void removeQueue(Queue queue, String clientId);
	
	/**
	 * Moves a queue object to the specific room
	 * 
	 * @param queue
	 * @param roomId
	 * @return returns the moved Queue object
	 */
	@RolesAllowed("gecam")
	public Queue moveToRoom(Queue queue, Integer roomId);
	
		
	/**
	 * Patient has left the building.
	 * 
	 * @param queue
	 * @return
	 */
	@RolesAllowed("gecam")
	public boolean leaveOffice(Queue queue);
	
	
	/**
	 * Returns all queues. Will return only queues that do not have an end date.
	 * 
	 * @return
	 */
	@RolesAllowed("gecam")
	public List<Queue> getAllQueues();

	
	/**
	 * Returns the queues of the room
	 * 
	 * @param roomId
	 * @return
	 */
	@RolesAllowed("gecam")
	public List<Queue> getQueues(Integer roomId);

//	/**
//	 * Create a new queue object in the room and fires jms update notification
//	 * @param kilometers 
//	 * @param isVisit 
//	 * @param reason 
//	 * 
//	 * @param id
//	 * @param id2
//	 */
//	@RolesAllowed("gecam")
//	public Queue createQueue(Integer patientId, Integer roomId, String comment, String clientId, Date entryDate, Boolean isVisit, Integer kilometers, Integer reason);

	@RolesAllowed("gecam")
	public Queue createQueue(Queue q, String clientId);

	/**
	 * @param clientId
	 * @param roomId
	 * @throws JMSException
	 */
	@RolesAllowed("gecam")
	public void sendQueueUpdateMessage(QueueUpdateEvent update) throws JMSException;

	/**
	 * @throws JMSException
	 */
	@RolesAllowed("gecam")
	public void sendRoomUpdateMessage() throws JMSException;
	
	
	/**
	 * @param id
	 * @return
	 */
	@RolesAllowed("gecam")
	public List<Queue> getQueues4Day(Integer id, Date day);
	
	
	public List<Queue> getQueues4Today4Physician(Integer physicianId);
	
	/**
	 * Imports appointments into waitingrooms 
	 * @param locale 
	 * @param sendMessages 
	 */
	@RolesAllowed("gecam")
	public void collectAppointments4Waitingrooms(Locale locale, boolean sendMessages);
	
	/**
	 * @param currentSiteId
	 * @return
	 */
	@RolesAllowed("gecam")
	public List<Room> getAllRooms(Integer currentSiteId);

	/**
	 * Returns a list of all queues of one patient.
	 *
	 * @param patientId
	 * @return List of queues
	 */
	@RolesAllowed("gecam")
	public List<Queue> getQueues4Patient(Integer patientId);
	
	/**
	 * Get the room be the room id.
	 * @param roomId
	 * @return the room
	 */
	@RolesAllowed("gecam")
	public Room getRoomById(Integer roomId);
	
	public List<Reason> getReasons();

}