/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.waitingroom.ejb.entity.beans;


import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;


/**
 * The queue entity is for patients that are in a waitingroom or in a consultation
 * room.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 15.03.2007
 * 16:59:00
 *
 *
 * @version
 * <br>$Log: Queue.java,v $
 * <br>Revision 1.8  2010-12-30 14:32:39  troth
 * <br>fixed problems with synchronization of Waitingroom and Agenda
 * <br>
 * <br>Revision 1.7  2009-10-06 14:16:13  hermen
 * <br>added isVisit to waitingroom entry
 * <br>
 * <br>Revision 1.6  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-05-07 14:39:53  heinemann
 * <br>new waitingroom
 * <br>
 * <br>Revision 1.4  2008-04-29 14:17:38  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2008-04-14 13:11:36  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2008-02-25 15:49:06  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2008-02-11 16:47:53  heinemann
 * <br>Initial checkin
 * <br>
 * <br>Revision 1.1  2007/03/27 05:55:22  heinemann
 * <br>initial checkin
 * <br>
 *
 */
@Entity
@Table(schema = "waitingroom", name = "queue")
public class Queue extends GECAMedEntityBean {

	// Fields

	private static final long serialVersionUID = 1L;
	
	
//	public static final String PROPERTY_PATIENTNAME 		= "patientname";
//	public static final String PROPERTY_UCM_CODE 			= "ucmcode";
//	public static final String PROPERTY_APPOINTMENT_START 	= "appointment_start_date";
//	public static final String PROPERTY_CALENDAR_COLOR      = "calendar_color";
	
	private Integer appointmentId;
	private Integer patientId;
	private String patientName;
	private String description;
	private Integer roomId;
	private Date startDate;
	private Date endDate;
	private Integer createdBy;
	private Integer orderId;
	private Integer	physicianId;
	private Boolean treated;
	private Boolean emergency;
	private Boolean isPresent;
	private Boolean isVisit;
	private Integer kilometers;
	private Integer reason;
	
//	private HashMap<String, Object> properties = new HashMap<String, Object>(0);
	
	/**
	 * 
	 */
	public Queue() {
		/* ================================================== */

		/* ================================================== */
	}
	
	
	/**
	 * @return the appointmentId
	 */
	@Column(name="appointment_id", nullable=true)
	public Integer getAppointmentId() {
		return appointmentId;
	}

	/**
	 * @param appointmentId the appointmentId to set
	 */
	public void setAppointmentId(Integer appointmentId) {
		this.appointmentId = appointmentId;
	}


	/**
	 * @return the patientId
	 */
	@Column(name="patient_id")
	public Integer getPatientId() {
		return patientId;
	}


	/**
	 * @param patientId the patientId to set
	 */
	public void setPatientId(Integer patientId) {
		this.patientId = patientId;
	}
	
	
	@Column(name="patient_name")
	public String getPatientName() {
		return patientName;
	}


	public void setPatientName(String patientName) {
		this.patientName = patientName;
	}




	/**
	 * @return the description
	 */
	@Column(name="description")
	public String getDescription() {
		return description;
	}


	/**
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}


	/**
	 * @return the roomId
	 */
	@Column(name="room_id")
	public Integer getRoomId() {
		return roomId;
	}


	/**
	 * @param roomId the roomId to set
	 */
	public void setRoomId(Integer roomId) {
		this.roomId = roomId;
	}


	/**
	 * @return the startDate
	 */
	@Column(name="start_date")
	public Date getStartDate() {
		return startDate;
	}


	/**
	 * @param startDate the startDate to set
	 */
	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}


	/**
	 * @return the endDate
	 */
	@Column(name="end_date")
	public Date getEndDate() {
		return endDate;
	}


	/**
	 * @param endDate the endDate to set
	 */
	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}


	/**
	 * @return the createdBy
	 */
	@Column(name="created_by")
	public Integer getCreatedBy() {
		return createdBy;
	}


	/**
	 * @param createdBy the createdBy to set
	 */
	public void setCreatedBy(Integer createdBy) {
		this.createdBy = createdBy;
	}


	/**
	 * @return the orderId
	 */
	@Column(name="order_id")
	public Integer getOrderId() {
		return orderId;
	}

	/**
	 * @param orderId the orderId to set
	 */
	public void setOrderId(Integer orderId) {
		this.orderId = orderId;
	}


	/**
	 * @return the physicianId
	 */
	@Column(name="physician_id")
	public Integer getPhysicianId() {
		return physicianId;
	}


	/**
	 * @param physicianId the physicianId to set
	 */
	public void setPhysicianId(Integer physicianId) {
		this.physicianId = physicianId;
	}
	
	
	
	
	/**
	 * @return the emegency
	 */
	@Column(name="emergency")
	public Boolean getEmergency() {
		if (emergency == null)
			return false;
		return emergency;
	}


	/**
	 * @param emegency the emegency to set
	 */
	public void setEmergency(Boolean emegency) {
		this.emergency = emegency;
	}


	/**
	 * @return the treated
	 */
	@Column(name="treated")
	public Boolean getTreated() {
		if (treated == null)
			return false;
		return treated;
	}


	/**
	 * @param treated the treated to set
	 */
	public void setTreated(Boolean treated) {
		this.treated = treated;
	}

	
	/**
	 * @return the isPresent
	 */
	@Column(name="is_present")
	public Boolean getIsPresent() {
		if (isPresent == null)
			return false;
		return isPresent;
	}


	/**
	 * @param isPresent the isPresent to set
	 */
	public void setIsPresent(Boolean isPresent) {
		this.isPresent = isPresent;
	}

	

	/**
	 * entry is a visit to the patient at home
	 * @return
	 */
	@Column(name="is_visit")
	public Boolean getIsVisit() {
	    return isVisit;
	}
	
	/**
	 * entry is a visit to the patient at home
	 * @param isVisit
	 */
	public void setIsVisit(Boolean isVisit) {
	    this.isVisit = isVisit;
	}
	
	@Column(name="kilometers")
	public Integer getKilometers() {
		return kilometers;
	}


	public void setKilometers(Integer kilometers) {
		this.kilometers = kilometers;
	}
	
	@Column(name="reason")
	public Integer getReason() {
		return reason;
	}


	public void setReason(Integer reason) {
		this.reason = reason;
	}

//	/**
//	 * @param key
//	 * @return
//	 */
//	@Transient
//	public Object getProperty(String key) {
//		/* ================================================== */
//		return this.properties.get(key);
//		/* ================================================== */
//	}
//	
//	/**
//	 * @param key
//	 * @param value
//	 */
//	@Transient
//	public void setProperty(String key, Object value) {
//		/* ================================================== */
//		this.properties.put(key, value);
//		/* ================================================== */
//	}
	
	
	public String toString() {
		return this.getId() + " Room:" + getRoomId()+ " AppID:" + getAppointmentId() + " "+ (this.getPatientName() !=null?this.getPatientName():"");
	}


	public String toToolTip() {
		return "<html>" +this.getStartDate() + "<br>" + 
				(this.getPatientName() !=null?this.getPatientName():"") + "<br>" +
				this.getDescription() + "<br>" +
				(this.getIsVisit() ?"Visit ":" Consultation ") + ((getKilometers()!= null && getKilometers() > 0)?getKilometers()+ "km":"") + "<br>" + 
				"Reason: " + (this.getReason()!= null?this.getReason():"-") + "<br>";
				
	}
	
}
