/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.usermanagement.gui.userlist;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.PasswordChangeDialog;
import lu.tudor.santec.gecamed.usermanagement.gui.userlist.UserManagementPanel.UserTableModel;
import lu.tudor.santec.i18n.Translatrix;

/**
 * TableCellEditor to enter passwords.
 * The editor provides a small dialog with 2 input field to retype the new password.
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @Version
 * <br>$Log: PasswordCellEditor.java,v $
 * <br>Revision 1.7  2009-05-07 08:26:45  hermen
 * <br>handle password changing without restarting
 * <br>
 * <br>Revision 1.6  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-01-15 10:18:39  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class PasswordCellEditor extends AbstractCellEditor implements TableCellEditor, TableCellRenderer
{

	public static final Color c_OddColor  = new Color (237,243,254);
	public static final Color c_EvenColor = new Color (255,255,255);
	private static final long serialVersionUID = 1L;
	private PasswordChangeDialog dialog = new PasswordChangeDialog(MainFrame.getInstance());
	private JButton component = new JButton(Translatrix.getTranslationString("um.change"));

	private JLabel renderer = new JLabel();
	private String passHash;
	private UserTableModel userTableModel;
	protected String pass;
		
	public PasswordCellEditor(UserTableModel userTableModel) {
	    this.userTableModel = userTableModel;
		component.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				String pw = dialog.getPassword();
				if (pw != null) {
					passHash = pw;
					pass = dialog.getUnencodedPassword();
				}
				fireEditingStopped();
			}
		});
	}
	
    /* (non-Javadoc)
     * @see javax.swing.table.TableCellEditor#getTableCellEditorComponent(javax.swing.JTable, java.lang.Object, boolean, int, int)
     */
    public Component getTableCellEditorComponent(
            JTable table, Object value,
            boolean isSelected, int rowIndex, int colIndex )
    {
    	passHash = (String) value ;
        return component;
    }

    /* (non-Javadoc)
     * @see javax.swing.CellEditor#getCellEditorValue()
     */
    public Object getCellEditorValue()
    {
        return passHash;
    }

	/* (non-Javadoc)
	 * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
	 */
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
		if (value == null) {
			renderer.setText("no Password!");
		} else {
			renderer.setText("******");
		}
		return renderer;
	}
}
