/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.usermanagement.gui.settings;

import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.Setting;
import lu.tudor.santec.gecamed.usermanagement.ejb.session.beans.LoginBean;
import lu.tudor.santec.gecamed.usermanagement.ejb.session.interfaces.LoginInterface;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.SettingsPanel;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/**
 * SettingPanel/Dialog which contains all system-wide settings plugins. 
 * this class extends lu.tudor.santec.gecamed.usermanagement.gui.settings.SettingsPanel 
 * but overwrites loading and saving of settings to a Setting EJB
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @Version
 * <br>$Log: GlobalSettingsPanel.java,v $
 * <br>Revision 1.15  2013-12-27 18:09:26  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.14  2013-11-05 14:51:10  ferring
 * <br>Using UTF-8 encoding, when storing settings
 * <br>
 * <br>Revision 1.13  2013-07-15 06:18:38  ferring
 * <br>logging changed
 * <br>
 * <br>Revision 1.12  2012-05-14 14:01:54  ferring
 * <br>XML settings are loaded explicitly as UTF-8, to avoid errors
 * <br>
 * <br>Revision 1.11  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.10  2008-05-28 14:28:17  hermen
 * <br>added sysout for debugging
 * <br>
 * <br>Revision 1.9  2008-05-23 07:41:32  hermen
 * <br>FIXED BUG WHEN ADDING PLUGINS AFTER LOADING THE SETTINGS
 * <br>
 * <br>Revision 1.8  2008-05-22 07:35:03  hermen
 * <br>added settings debug
 * <br>
 * <br>Revision 1.7  2008-05-19 10:06:55  hermen
 * <br>now settings are only loaded once and the access to the settings is now synchronized.
 * <br>
 * <br>Revision 1.6  2008-01-15 10:18:39  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class GlobalSettingsPanel extends SettingsPanel {
	
	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(GlobalSettingsPanel.class.getName());
	
	private static final long serialVersionUID = 1L;
	private LoginInterface manager;
	private Setting settings;

	public GlobalSettingsPanel(Frame p_Owner) {
		super(p_Owner);
		Translatrix.addBundle("lu.tudor.santec.settings.resources.WidgetResources");
		 // Get the type manager
		manager = (LoginInterface) ManagerFactory.getRemote(LoginBean.class);
	}

    /**
     * saves current settings to settings ejb
     * @see setSettingsFile
     */
    public synchronized void saveSettings() {
        try {
            ByteArrayOutputStream bStream = new ByteArrayOutputStream();
            writeSettings(bStream);
            this.settings.setSettingData(bStream.toString("UTF-8"));
            manager.saveGlobalSettings(this.settings);
            logger.log(Level.INFO,"Global Settings saved");
        } catch(Exception p_Exception) {
            logger.log(Level.WARN,"Saving Global Settings failed",p_Exception);
        }
    }
    
    /**
     * loads settings from UmSettings bean
     * @see setSettingsFile
     */
    public synchronized void loadSettings() {
            try {
            	logger.log(Level.INFO,"loading Global Settings....................................");
            	this.settings = manager.getGlobalSettings();
            	if (this.settings == null) {
            		logger.log(Level.WARN,"no Global Settings found, creatign new ones");
            		this.settings = new Setting();
            	} else {
            		logger.log(Level.INFO,"Global Settings loaded");
	                ByteArrayInputStream bStream  = new ByteArrayInputStream(settings.getSettingData().getBytes("UTF-8"));
	                readSettings(bStream);
            	}
            } catch(Exception p_Exception) {
                logger.log(Level.WARN,"Loading of Global Settings  failed",p_Exception);
                System.err.println(new String(settings.getSettingData().getBytes()));
            }
        reflectSettings();
    }
    
    /* (non-Javadoc)
     * @see lu.tudor.santec.settings.SettingsPanel#reflectSettings()
     */
    @Override
    public synchronized void reflectSettings() {
//	long start = System.currentTimeMillis();
//	System.out.println("\treflect ADMIN Settings");
//	System.out.flush();
	super.reflectSettings();
//	System.out.println("\treflect ADMIN Settings done (took " + (System.currentTimeMillis()-start) + " )");
//	System.out.flush();
    }

}
