///*****************************************************************************
// *                                                                           *
// *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
// *                                                                           *
// *                                                                           *
// *  This library is free software; you can redistribute it and/or modify it  *
// *  under the terms of the GNU Lesser General Public License as published    *
// *  by the Free Software Foundation; either version 2 of the License, or     *
// *  (at your option) any later version.                                      *
// *                                                                           *
// *  This software is distributed in the hope that it will be useful, but     *
// *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
// *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
// *  Lesser General Public License for more details.                          *
// *                                                                           *
// *  You should have received a copy of the GNU Lesser General Public         *
// *  License along with this library; if not, write to the Free Software      *
// *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
// *                                                                           *
// *****************************************************************************/
//package lu.tudor.santec.gecamed.usermanagement.gui;
//
//import java.awt.Color;
//import java.awt.Font;
//import java.awt.event.ActionEvent;
//import java.awt.event.ActionListener;
//
//import java.util.List;
//
//import javax.swing.JButton;
//import javax.swing.JPanel;
//import javax.swing.JProgressBar;
//import javax.swing.JScrollPane;
//import javax.swing.JTextArea;
//import javax.swing.SwingConstants;
//import javax.swing.UIManager;
//
//import com.jgoodies.forms.layout.CellConstraints;
//import com.jgoodies.forms.layout.FormLayout;
//
//import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
//import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialog;
//import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
//import lu.tudor.santec.gecamed.patient.ejb.session.beans.IncidentManagerBean;
//import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.IncidentManager;
//import lu.tudor.santec.i18n.Translatrix;
//
//
///** 
// * Dialog where user can delete all patient incidents with no incident entries.
// * To open the dialog navigate in main menu to Admin/Cleanup Incidents.
// * 
// * @author Thorsten Roth thorsten.roth(at)tudor.lu
// *
// * @version
// * <br>$Log: DataBaseDialogNullIncident.java,v $
// * <br>Revision 1.4  2010-11-05 15:06:29  troth
// * <br>sub the new dialog to the main menu bar for delete the incidents how have no incident entries. The function of the dialog is now implement in the function 'create Incidententries for Prescription how have one together'.
// * <br>
// * <br>Revision 1.3  2010-10-15 14:57:42  troth
// * <br>add function to create Incidententries for Prescription how have one together
// * <br>
// * <br>Revision 1.2  2010-10-14 09:24:53  troth
// * <br>fix little GUI bugs
// * <br>
// * <br>Revision 1.1  2010-10-13 15:02:53  troth
// * <br>Add new dialog to the main menu bar for delete the incidents how have no incident entries.
// * <br>
// */
//public class DataBaseDialogNullIncident extends GECAMedBaseDialog{
//
//	private static final long serialVersionUID = 1L;
//
//	private CellConstraints cc;
//	
//	private JProgressBar progressBar;
//	
//	private JButton startButton;
//	
//	private JButton stopButton;
//	
//	private JTextArea textArea;
//	
//	private JPanel parentPanel;
//	
//	private Thread thread;
//	
//	private Boolean stop;
//
//	private int incidentListSize;
//	
//	private List<Integer> patientIds;
//	
//	private IncidentManager incidentManager;
//	
//	private static final Color SPLASH_TEXTCOLOR = new Color(0,67,134);
//	
//	private long runTime;
//	
//	private String infoText;
//	
//	
//	/**
//	 * Constructor
//	 * 
//	 * @param title of dialog
//	 */
//	public DataBaseDialogNullIncident(String title) {
//		super(title,true,false);
//		
//		this.incidentManager = (IncidentManager) ManagerFactory.getRemote(IncidentManagerBean.class);
//		this.setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
//		
//		this.initValues();
//		this.initComponents();
//		this.buildPanel();
//		
//		this.pack();
//	}
//
//
//	/**
//	 * init all values
//	 */
//	private void initValues() {
//		this.stop = false;
//		
//		this.patientIds = this.incidentManager.getNullIncident();
//		
//		if(this.patientIds.size() > 0) this.infoText = Translatrix.getTranslationString("dbDialogNullIncident.infoTextNullIncidents");
//		else this.infoText = Translatrix.getTranslationString("dbDialogNullIncident.infoTextNoIncidents");
//		
//		this.incidentListSize = patientIds.size();
//	}
//
//	
//	/**
//	 * build the dialog gui 
//	 */
//	private void buildPanel()
//	{
//		this.parentPanel = new JPanel(
//				new FormLayout(
//						// cols
//						"3dlu," +
//						"fill:pref:grow," +
//						"25dlu," +
//						"fill:pref:grow," +
//						"3dlu",
//						// rows
//						"3dlu," +
//						"fill:200dlu," + // info text
//						"3dlu," +
//						"fill:25dlu," + // progressBar
//						"3dlu," +
//						"fill:20dlu," + // buttons
//						"3dlu"));
//		this.parentPanel.setBackground(GECAMedColors.c_GECAMedBackground);
//		this.parentPanel.setOpaque(false);
//		
//		this.cc = new CellConstraints();
//		if(this.patientIds.size() > 0)
//		{
//			this.parentPanel.add(new JScrollPane(this.textArea), 	cc.xyw(2, 2, 3));
//			this.parentPanel.add(this.progressBar,					cc.xyw(2, 4, 3));
//			this.parentPanel.add(this.startButton,					cc.xyw(2, 6, 1));
//			this.parentPanel.add(this.stopButton,					cc.xyw(4, 6, 1));
//		}else
//			this.parentPanel.add(new JScrollPane(this.textArea),	cc.xywh(2, 2, 3, 5));
//		
//		this.add(parentPanel);
//	}
//	
//	/**
//	 * init dialog components
//	 */
//	private void initComponents()
//	{
//		// init info text
//		this.textArea = new JTextArea();
//		this.textArea.setText(infoText);
//		this.textArea.setFont(new Font(null, Font.BOLD, 14));
//		this.textArea.setEditable(false);
//		this.textArea.setLineWrap(true);
//        this.textArea.setWrapStyleWord(true);
//		this.textArea.setAutoscrolls(true);
//		this.textArea.setSize(400, 400);
//		
//		// init progressBar
//		this.progressBar = new JProgressBar(SwingConstants.HORIZONTAL, 0, this.incidentListSize);
//		UIManager.put("ProgressBar.selectionBackground",SPLASH_TEXTCOLOR);
//        this.progressBar.setStringPainted(true);
//        this.progressBar.setBackground(Color.WHITE);
//        this.progressBar.setForeground(SPLASH_TEXTCOLOR);
//        this.progressBar.setString("0 / " + incidentListSize);
//        
//        // init buttons
//		this.startButton = new JButton(Translatrix.getTranslationString("dbDialogNullIncident.startButton"));
//		this.startButton.setEnabled(true);
//		this.startButton.addActionListener(new ActionListener() {
//			public void actionPerformed(ActionEvent e) {
//				
//				startButton.setEnabled(false);
//				stopButton.setEnabled(true);
//				okButton.setEnabled(false);
//				progressBar.setMaximum(incidentListSize);
//				initValues();
//				//stop = false;
//				runTime = System.currentTimeMillis();
//				thread = new Thread(new Runnable() {
//					public void run()
//					{
//						int i = 0;
//						for (Integer pId : patientIds)
//						{
//							if(stop)
//								break;
//							
//							progressBar.setValue(i);
//							//progressBar.setString("check id: " + pId + " | " + i + " / " + incidentListSize);
//							progressBar.setString(i + " / " + incidentListSize);
//							// look for and delete incident witch have no incident entries
//							incidentManager.deleteNullIncident(pId);
//							try
//							{
//								Thread.sleep(10);
//							} catch (Exception ex) {
//							}
//							i++;
//						}
//						startButton.setEnabled(true);
//						stopButton.setEnabled(false);
//						okButton.setEnabled(true);
//						progressBar.setString(Translatrix.getTranslationString("dbDialogNullIncident.labelProgressBarComplete") + (System.currentTimeMillis()-runTime)/1000 + " sec. | " + i + " / " + incidentListSize);
//					}
//				});
//				thread.start();
//			}
//		});
//		
//		this.stopButton = new JButton(Translatrix.getTranslationString("dbDialogNullIncident.stopButton"));
//		this.stopButton.setEnabled(false);
//		this.stopButton.addActionListener(new ActionListener() {
//			public void actionPerformed(ActionEvent e) {
//				stop = true;
//				startButton.setEnabled(true);
//				stopButton.setEnabled(false);
//			}
//		});
//		
//		this.okButton.setText(Translatrix.getTranslationString("core.close"));
//		this.okButton.setIcon(null);
//	}
//}