/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.usermanagement.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Vector;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import lu.tudor.santec.gecamed.address.gui.addressmanagement.AddressImportPanel;
import lu.tudor.santec.gecamed.core.gui.GECAMedAction;
import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.GECAMedTab;
import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.utils.GECAMedUtils;
import lu.tudor.santec.gecamed.esante.gui.ESanteManagementPanel;
import lu.tudor.santec.gecamed.esante.gui.utils.ESanteGuiUtils;
import lu.tudor.santec.gecamed.importexport.gui.importer.ImportManagementPanel;
import lu.tudor.santec.gecamed.office.gui.officemanagement.OfficeManagementPanel;
import lu.tudor.santec.gecamed.office.gui.physicianmanagement.PhysicianManagementPanel;
import lu.tudor.santec.gecamed.usermanagement.gui.log.LogManagementPanel;
import lu.tudor.santec.gecamed.usermanagement.gui.userlist.UserManagementPanel;
import lu.tudor.santec.i18n.Translatrix;

/**
 * This Class builds a new GECAMedModule with all Admin Panels like
 * user / office / physician management, logging, address-import
 * This module will only be shown if the current user obtains the admin role.
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * $Version$
 * <br>$Log: AdminModule.java,v $
 * <br>Revision 1.54  2014-02-06 14:34:37  ferring
 * <br>eSanté Management panel was put before the logging panel
 * <br>
 * <br>Revision 1.53  2014-01-15 14:16:42  ferring
 * <br>eSante management panel will only be loaded, if the eSante tab is activated
 * <br>
 * <br>Revision 1.52  2013-12-13 15:26:27  troth
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.51  2013-12-10 16:40:15  troth
 * <br>Admin tab for eSante.
 * <br>
 * <br>Revision 1.50  2012-11-05 14:23:42  ferring
 * <br>fix amount for acts entered into DB
 * <br>
 * <br>Revision 1.49  2012-05-25 13:40:20  ferring
 * <br>panel will be refreshed, whenever it is shown
 * <br>
 * <br>Revision 1.48  2010-11-05 15:06:29  troth
 * <br>sub the new dialog to the main menu bar for delete the incidents how have no incident entries. The function of the dialog is now implement in the function 'create Incidententries for Prescription how have one together'.
 * <br>
 * <br>Revision 1.47  2010-10-18 07:47:54  troth
 * <br>add translations - for the function create Incidententries for Prescription how have one together
 * <br>
 * <br>Revision 1.46  2010-10-15 14:57:42  troth
 * <br>add function to create Incidententries for Prescription how have one together
 * <br>
 * <br>Revision 1.45  2010-10-13 15:02:53  troth
 * <br>Add new dialog to the main menu bar for delete the incidents how have no incident entries.
 * <br>
 * <br>Revision 1.44  2010-04-21 09:41:59  hermen
 * <br>small bugfixes
 * <br>
 * <br>Revision 1.43  2010-04-21 08:17:58  hermen
 * <br>added scrollbar
 * <br>
 * <br>Revision 1.42  2010-04-08 14:57:14  hermen
 * <br>jasper templates are now compiled on demand from the jrxml files
 * <br>
 * <br>Revision 1.41  2010-03-19 12:01:06  hermen
 * <br>improved and unified iconfetching
 * <br>
 * <br>Revision 1.40  2010-03-12 14:46:22  hermen
 * <br>icon cleanup
 * <br>
 * <br>Revision 1.39  2009-02-11 14:05:53  hermen
 * <br>added management of sites to the office admin tab
 * <br>
 * <br>Revision 1.38  2009-01-19 15:57:57  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.37  2008-11-26 13:55:11  hermen
 * <br>added getGecamedUser(String login)
 * <br>
 * <br>Revision 1.36  2008-09-29 14:16:18  hermen
 * <br>modified firstrun Actions
 * <br>
 * <br>Revision 1.35  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.34  2008-09-24 09:11:52  heinemann
 * <br>added first run actions to gecamed. will disable all views except the ones of the admin tab for user, office and physician.
 * <br>Tabs are enabled, if an physican was saved.
 * <br>
 * <br>Revision 1.33  2008-07-18 13:44:32  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.32  2008-04-15 09:59:36  hermen
 * <br>added backup options
 * <br>
 * <br>Revision 1.31  2008-04-08 09:52:33  heinemann
 * <br>moved creation of new calendar from OfficeBean to AgendaModule
 * <br>
 * <br>Revision 1.30  2008-04-07 16:56:33  mack
 * <br>NomenclaturePanel is now added by BillingModule
 * <br>
 * <br>Revision 1.29  2008-04-07 13:10:36  hermen
 * <br>added Mainframe.addAdminTab to allow modules to add their own tabs to the admin module.
 * <br>
 * <br>Revision 1.28  2008-04-01 08:18:00  hermen
 * <br>added backup settings
 * <br>
 * <br>Revision 1.27  2008-02-22 13:09:54  mack
 * <br>Added new Billing Module Admin Config Panel
 * <br>
 * <br>Revision 1.26  2008-01-15 10:18:39  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class AdminModule extends GECAMedModule
{
    //~ Static fields/initializers =============================================

    private static final long serialVersionUID = 1L;

    /** the logger Object for this class */
//	private static Logger logger = Logger.getLogger(AdminModule.class.getName()); 

    /**
     * The name of the module 
     */
    public static final String MODULE_NAME = "Admin";
    
    public static final String ICON_ADMIN = "admin.png";
    
    public static final String ICON_USERMANAGEMENT = "group.png";
    
    public static final String ICON_ERROR = "error.png";
    
    public static final String ICON_SYSTEM = "system.png";
    
    public static final String ICON_OK = "button_ok.png";
    
	private JTabbedPane tabbedPane;
    
	// tabs
    private AddressImportPanel			addressImportPanel;
    private UserManagementPanel			userManagementPanel;
    private OfficeManagementPanel		officeManagementPanel;
    private PhysicianManagementPanel	physicianManagementPanel;
    private ImportManagementPanel		importManagementPanel;
    private LogManagementPanel			logManagementPanel;
    private ESanteManagementPanel		esanteManagementPanel;
	
	private boolean hasBeenBuild = false;

	private static JMenu adminMenu = new JMenu("Admin");
	
	private static Vector<GECAMedAction> adminActions = new Vector<GECAMedAction>();
    
	private static AdminModule adminModule;
	
	private Vector<GECAMedTab> admintabs = new Vector<GECAMedTab>();
	
    //~ Instance fields ========================================================
	
    //~ Constructors ===========================================================
    /**
     * creates a new AdminPanel
     *
     * @param mainFrame a reference to the mainFrame of the Program to obtain all child-objects from
     */ 
    public AdminModule()
    {
    	super(MODULE_NAME, getIcon(ICON_ADMIN), Color.RED);
    	
    	this.setOpaque(false);
    	adminModule = this;
    	// add the ResourceBundle for: lu.tudor.santec.gecam.client.gui.administration
    	Translatrix.addBundle("lu.tudor.santec.gecamed.usermanagement.gui.resources.WidgetResources");
    	Translatrix.addBundle("lu.tudor.santec.gecamed.office.gui.resources.WidgetResources");
		
    	// add the menu
    	adminMenu.setText(Translatrix.getTranslationString("Admin"));
    	if (! GECAMedUtils.isDemo() || MainFrame.isAdmin()) {
    		this.setModuleMenu(adminMenu);
    	}
    	
//    	// add the menu item cleanupDbDeleteIncident to delete all patient incidents with no incident entries
//    	JMenuItem cleanupDbDeleteIncident = new JMenuItem(new AbstractAction(Translatrix.getTranslationString("dbDialogNullIncident.menuItemName"), 
//        		GECAMedModule.getMiniIcon(GECAMedIconNames.BUG)) {
//					private static final long serialVersionUID = 1L;
//					public void actionPerformed(ActionEvent e)
//					{
//						// Open Dialog
//						DataBaseDialogNullIncident checkDataBaseDialog = new DataBaseDialogNullIncident(Translatrix.getTranslationString("dbDialogNullIncident.title"));
//						MainFrame.showDialogCentered(checkDataBaseDialog);
//					}
//		        });
//		        adminMenu.add(cleanupDbDeleteIncident);
//    	
//    	this.mainFrame = MainFrame.getInstance();
    	
    	// add the menu item checkDataBaseDialog to create incidents entries for prescriptions how have one incident entries together
    	JMenuItem menuItem = new JMenuItem(new AbstractAction(Translatrix.getTranslationString("dbDialogCreatePrescriptionIncidentsEntries.menuItemName"), 
        		GECAMedModule.getMiniIcon(GECAMedIconNames.BUG)) {
					private static final long serialVersionUID = 1L;
					public void actionPerformed(ActionEvent e)
					{
						// Open Dialog
						DataBaseDialogCreatePrescriptionIncidentsEntries checkDataBaseDialog = new DataBaseDialogCreatePrescriptionIncidentsEntries(Translatrix.getTranslationString("dbDialogCreatePrescriptionIncidentsEntries.title"));
						MainFrame.showDialogCentered(checkDataBaseDialog);
					}
		});
		adminMenu.add(menuItem);
    	
		// add the menu item "set amount of billing acts"
		menuItem = new JMenuItem(new AbstractAction(
				Translatrix.getTranslationString("GeneralSettings.ActAmountDialog.menuItem"), 
    					GECAMedModule.getMiniIcon(GECAMedIconNames.BUG))
    	{
			private static final long serialVersionUID = 1L;
			public void actionPerformed(ActionEvent e)
			{
				new ActAmountDialog().setVisible(true);
			}
        });
        adminMenu.add(menuItem); 
		        
		        
    	this.mainFrame = MainFrame.getInstance();
    	
//    	new GECAMedAction (this,
//				"",
//				AdminModule.getIcon(AdminModule.ICON_USERMANAGEMENT),
//				KeyEvent.VK_U,
//				true, true, false) {
//					private static final long serialVersionUID = 1L;
//					public void actionPerformed (ActionEvent p_Event) 
//				    {
//						try {
//						    
//						} catch (Exception e) {
//						}
//				    }
//	    }.add(true);
//	    
//    	new GECAMedAction (this,
//				"office.office",
//				GECAMedModule.getIcon(GECAMedIconNames.OFFICE),
//				KeyEvent.VK_O,
//				true, true, false) {
//					private static final long serialVersionUID = 1L;
//					public void actionPerformed (ActionEvent p_Event) 
//				    {
//						try {
//							MainFrame.getInstance().selectModule(AdminModule.this.getName());
//							tabbedPane.setSelectedComponent(officemanagementPanel);							
//						} catch (Exception e) {
//						}
//				    }
//	    }.add();
//	    
//    	new GECAMedAction (this,
//				"office.physicianmanagement",
//				PatientManagerModule.getIcon(PatientManagerModule.PHYSICIAN),
//				KeyEvent.VK_P,
//				true, true, false) {
//					private static final long serialVersionUID = 1L;
//					public void actionPerformed (ActionEvent p_Event) 
//				    {
//						try {
//							MainFrame.getInstance().selectModule(AdminModule.this.getName());
//							tabbedPane.setSelectedComponent(physicianManagementPanel);							
//						} catch (Exception e) {
//						}
//				    }
//	    }.add(true);
    }
    
	
	/**
	 * loads/creates all the tabs and adds them to the tabbedpane
	 */
	private void loadTabs()
	{
		addressImportPanel			= new AddressImportPanel();
		userManagementPanel			= new UserManagementPanel();
		officeManagementPanel		= new OfficeManagementPanel();
		physicianManagementPanel	= new PhysicianManagementPanel();
		importManagementPanel		= new ImportManagementPanel();
		logManagementPanel			= new LogManagementPanel();

		this.admintabs.add(userManagementPanel);
		this.admintabs.add(physicianManagementPanel);
		this.admintabs.add(officeManagementPanel);
		this.admintabs.add(addressImportPanel);

		// load the modules admin tabs
		this.admintabs.addAll(MainFrame.getAdminTabs());
		
		if (ESanteGuiUtils.isESanteModuleActivated())
		{
			esanteManagementPanel = new ESanteManagementPanel();
			this.admintabs.add(esanteManagementPanel);
		}

		this.admintabs.add(importManagementPanel);
		this.admintabs.add(logManagementPanel);
		
		
		// add all tabs th the tabbedpane
		for (GECAMedTab tab : this.admintabs)
		{
			tab.addToTabbedPane(this.tabbedPane);
		}
	}


    /**
     * adds the components to the panel
     */
    private void buildPanel()
    {
        // initialize Components
        initComponents();
        
        JScrollPane jsp = new JScrollPane(tabbedPane);
        setContentPanel(jsp);
        this.hasBeenBuild = true;
        
	    
		if (GECAMedUtils.isDemo() && !MainFrame.isAdmin()) {
		   	// disables all tabs
			for (GECAMedTab tab : this.admintabs) {
			    tab.enablePanel(false);
			}
		} else {
		   	// enables all tabs
			for (GECAMedTab tab : this.admintabs) {
			    tab.enablePanel(true);
			}
		}
    }

    /**
     * initialises the Components
     */
    private void initComponents()
    {
        tabbedPane = new JTabbedPane();
        tabbedPane.addChangeListener(new ChangeListener() {
          
			public void stateChanged(ChangeEvent e) {
				// TODO Auto-generated method stub
				 System.out.println("Tab: " + tabbedPane.getSelectedIndex());
				 if(tabbedPane.getSelectedIndex()==1){
					 physicianManagementPanel.isOnScreen=true;
				 }
				 else
				 {
					 physicianManagementPanel.isOnScreen=false;
				 }
			}
        });
    	this.loadTabs();
     }

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.GECAMedModule#preparetoShowup()
	 */
	@Override
	public void preparetoShowup() {
		if (hasBeenBuild) 
		{
			if (tabbedPane.getSelectedComponent() == logManagementPanel)
				logManagementPanel.refreshList();
		} 
		else 
		{
			MainFrame.getInstance().setWaitCursor(true);
			this.buildPanel();	
		}
	}
	

	public static ImageIcon getScaledIcon(String p_IconName, int size) 
	{
	    return IconFetcher.getScaledIcon(AdminModule.class, p_IconName, size);
	}
	
//	---------------------------------------------------------------------------

	public static ImageIcon getSmallIcon(String p_IconName) {
	    return IconFetcher.getSmallIcon(AdminModule.class, p_IconName);
	}
	
	
	public static ImageIcon getIcon(String p_IconName) 
	{
	    return IconFetcher.getIcon(AdminModule.class, p_IconName);
	}
	
	
	public static void addAdminAction(GECAMedAction action) {
		/* ====================================================== */
		adminActions.add(action);
		if (action.isMenuAction()) {
			adminMenu.add(action);
		}
		/* ====================================================== */
	}
	
	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.GECAMedModule#relocalize()
	 */
	public void relocalize() {
		/* ====================================================== */
		/* ====================================================== */
	}
	
	/**
	 * Returns the instance of the module
	 * 
	 * @return
	 */
	public static AdminModule getInstance() {
		/* ====================================================== */
		return adminModule;
		/* ====================================================== */
	}
	
	
	public void setAllTabsEnabled(boolean b) {
		/* ================================================== */
		for (GECAMedTab t : this.admintabs) {
//			t.setEnabled(b);
			tabbedPane.setEnabledAt(tabbedPane.indexOfComponent(t), b);
		}
		/* ================================================== */
	}
	
	public void setTabEnabled(Class<?> tabClass, boolean b) {
		/* ================================================== */
		for (GECAMedTab t : this.admintabs) {
			if (t.getClass().equals(tabClass)) {
				tabbedPane.setEnabledAt(tabbedPane.indexOfComponent(t), b);
				return;
			}
		}
		/* ================================================== */
	}
	
	
}
