/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.usermanagement.ejb.session.interfaces;

import java.util.Collection;

import javax.annotation.security.RolesAllowed;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.GecamedUser;
import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.Permission;
import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.Role;

/**
 * This Bean-Class manages the Administration of the different GeCam Users 
 * it provides methods to grand, retrieve rights to a user and add and delete
 * or modify users. Use this class to list, update and create new Users.
 * 
 * @author Johannes Hermen
 * @updated 11.10.2005 Martin Heinemann
 * @updated 15.06.2006 Johannes Hermen
 * 
 * @Version
 * <br>$Log: UserAdminInterface.java,v $
 * <br>Revision 1.10  2008-11-26 13:55:11  hermen
 * <br>added getGecamedUser(String login)
 * <br>
 * <br>Revision 1.9  2008-09-25 09:43:08  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.8  2008-01-15 09:30:14  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public interface UserAdminInterface {

	//~ Methods ================================================================

	/**
	 * Returns a User Object of the spezified User
	 *
	 * @param userID the Id of the wanted User
	 * @return a User Object representing the spezified User
	 * @author Johannes Hermen
	 * @updated 09.12.2005 Martin Heinemann
	 */
	@RolesAllowed("gecam")
	public abstract GecamedUser getUser(Integer userID) throws NamingException,
			FinderException;
	
	
	/**
	 * Returns a User Object of the spezified User
	 *
	 * @param login the login of the wanted User
	 * @return a User Object representing the spezified User
	 * @author Johannes Hermen
	 * @updated 09.12.2005 Martin Heinemann
	 */
	@RolesAllowed("gecam")
	public abstract GecamedUser getUser(String login) throws NamingException,
			FinderException;

	/**
	 * returns an Array of all existing User as User[]
	 *
	 * @return an Array of all existing User Objects
	 * @author Johannes Hermen
	 * @updated 11.10.2005 Martin Heinemann
	 */
	@SuppressWarnings("unchecked")
	@RolesAllowed("gecam")
	public abstract Collection<GecamedUser> getUserList() throws FinderException;

	/**
	 * saves or creates a user
	 *
	 * @param user User Object
	 * @throws Exception
	 * @ejb.interface-method view-type = "remote"
	 * 
	 * @author Johannes Hermen
	 * @updated 09.12.2005 Martin Heinemann
	 */
	@RolesAllowed("gecam")
	public abstract GecamedUser saveUser(GecamedUser user) throws Exception;

	/**
	 * deletes the User specified by its id
	 *
	 * @param userID the id of the User to be deleted
	 * @throws Exception
	 * @ejb.interface-method view-type = "remote"
	 * 
	 * @author Johannes Hermen
	 * @updated 09.12.2005 Martin Heinemann
	 */
	@RolesAllowed("gecam")
	public abstract void deleteUser(Integer userID) throws Exception;


	/**
	 * returns a Collection of all available Roles
	 * @return a Collection of all available Roles
	 */
	@RolesAllowed("gecam")
	public Collection<Role> getRoles();
	
	
	
	/**
	 * returns a Collection of all available Permissions
	 * @return a Collection of all available Permissions
	 */
	@RolesAllowed("gecam")
	public Collection<Permission> getPermissions();
	
	/**
	 * Returns all permissions for a user, also the permissions
	 * inherited fromt he roles, the user is assigned to
	 * 
	 * @param userId
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public Collection<Permission> getPermissions(Integer userId);
	
}
