/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Entity Bean that maps the <b>usermanagement.message</b> table which stores all usermessages form users send with the MessageSendDialog.
 * 
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: UserMessage.java,v $
 * <br>Revision 1.3  2013-12-27 18:09:26  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.2  2012-03-20 14:35:00  ferring
 * <br>Default values initialised
 * <br>
 * <br>Revision 1.1  2010-02-09 13:37:12  troth
 * <br>Create Entity Bean that maps the usermanagement.message table which stores all usermessages form users send with the MessageSendDialog.
 * <br>
 */

@NamedQuery(name = UserMessage.QUERY_FIND_ALL_USERMESSAGE, query = "SELECT OBJECT(o) FROM UserMessage o WHERE o.receiverId = :" + UserMessage.PARA_RECEIVER_ID + " or o.receiverId is NULL ORDER BY date ASC")

@Entity
@Table(name = "message", schema = "usermanagement")
public class UserMessage extends GECAMedEntityBean implements Serializable {

	private static final long serialVersionUID = 1L;

	public static final String QUERY_FIND_ALL_USERMESSAGE = "findAllUserMessage";
	public static final String QUERY_FIND_ALL_USERMESSAGE_IS_READ = "findAllUserMessage";
	public static final String PARA_RECEIVER_ID = "receiverId";
	
	private Integer senderId;
	private Integer receiverId;
	private String 	message;
	private Date 	date;
	private Boolean isRead;
	private Boolean isImportant;
	private Boolean allUser;
	
	
	
	public UserMessage()
	{
		date 		= new Date();
		isRead 		= Boolean.FALSE;
		isImportant = Boolean.FALSE;
		allUser 	= Boolean.FALSE;
	}
	
	
	/**
	 * get the sender id
	 * @return senderId the sender id
	 */
	@Column(name = "sender_id")
	public Integer getSenderId() {
		return senderId;
	}
	
	/**
	 * set the sender id
	 * @param senderId the sender id
	 */
	public void setSenderId(Integer senderId) {
		this.senderId = senderId;
	}
	
	/**
	 * get the receiver id
	 * @return receiverId the receiver id
	 */
	@Column(name = "receiver_id")
	public Integer getReceiverId() {
		return receiverId;
	}
	
	/**
	 * set the receiver id
	 * @param receiverId the receiver id
	 */
	public void setReceiverId(Integer receiverId) {
		this.receiverId = receiverId;
	}
	
	/**
	 * get the text message
	 * @return message the text message
	 */
	@Column(name ="message")
	public String getMessage() {
		return message;
	}
	
	/**
	 * set the text message
	 * @param message the text to set
	 */
	public void setMessage(String message) {
		this.message = message;
	}
	
	/**
	 * get the date of the message
	 * @return date the date of the message
	 */
	@Column(name = "date")
	public Date getDate() {
		return date;
	}
	
	/**
	 * set the date of the message
	 * @param date the date to set
	 */
	public void setDate(Date date) {
		this.date = date;
	}

	/**
	 * get the read flag of a message
	 * @return isRead the read flag if its true = message is marked as read | false = message is marked as not read
	 */
	@Column(name = "read")
	public Boolean getIsRead() {
		return isRead;
	}
	
	/**
	 * set the read flag of a message
	 * @param isRead the read flag if its true = message is marked as read | false = message is marked as not read
	 */
	public void setIsRead(Boolean isRead) {
		this.isRead = isRead;
	}
	
	/**
	 * get the important flag of a message
	 * @return isImportant the important flag if its true = message is important | false = message is not important
	 */
	@Column(name = "important")
	public Boolean getIsImportant() {
		return isImportant;
	}
	
	/** set the important flag of a message
	 * @param isImportant the important flag if its true = message is important | false = message is not important
	 */
	public void setIsImportant(Boolean isImportant) {
		this.isImportant = isImportant;
	}
	
	/**
	 * get the alluser flag of a message
	 * @return allUser the alluser flag if its true = message has to send to all users | false = message has to send to only one user 
	 */
	@Column(name = "all_user")
	public Boolean getAllUser() {
		return allUser;
	}
	
	/**
	 * set the alluser flag of a message
	 * @param allUser the alluser flag if its true = message has to send to all users | false = message has to send to only one user
	 */
	public void setAllUser(Boolean allUser) {
		this.allUser = allUser;
	}
}
