/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/

package lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans;

import java.io.Serializable;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Entity Bean that maps the <b>usermanagement.setting</b> table
 * this table stores the settings per user -> userId and the global system settings -> userId = -1
 * as an xml stream which is read and wrote by the lu.tudor.santec.settings library.
 * 
 * @Author Johannes Hermen Tudor/Santec
 *         		Martin Heinemann Tudor/Santec
 *
 * @Version
 * <br>$Log: Setting.java,v $
 * <br>Revision 1.8  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.7  2008-01-15 09:30:13  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.6  2008-01-08 09:08:13  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
@javax.persistence.NamedQueries({

    // NamedQueries using Fields.
    @javax.persistence.NamedQuery(name="findSettingByUserID",
        query="SELECT OBJECT(o) FROM Setting o WHERE o.userId = :userId")
})


@javax.persistence.Entity
@javax.persistence.Table(name = "setting", schema = "usermanagement")
public class Setting extends GECAMedEntityBean implements Serializable {
    
    private static final long serialVersionUID = 1L;

    
    public Setting() {
        super();
    }
   

	/** Regular field. */
	private Integer userId;

	/**
	 * the userID of the user belonging to this settings.
	 * @return  userID of the user belonging to this settings.
	 */
	@javax.persistence.Column(name = "user_id")
	public Integer getUserId() {
		return userId;
	}

	/**
	 * sets the  userID of the user belonging to this settings.
	 * @param userId  userID of the user belonging to this settings.
	 */
	public void setUserId(Integer userId) {
		this.userId = userId;
	}

	/** Regular field. */
	private String settingData;

	/**
	 * Get the settingData.
	 *
	 * @return The settingData.
	 */
	@javax.persistence.Column(name = "xml_config")
	public String getSettingData() {
		return settingData;
	}

	/**
	 * Set the settingData.
	 *
	 * @param data The settingData.
	 */
	public void setSettingData(String settingData) {
		this.settingData = settingData;
	}
	
}
