/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

//***************************************************************************
//* Class Definition and Members                                            	*
//*																		*
//* History 																*
//* Version    Date    Authors Modification								*
//*  1.0    06/06/21   nmac    Initial Release								*
//***************************************************************************

/**
 * Entity Bean that maps the <b>usermanagement.rel_role_permission</b> table
 * 
* The Role class represents a given set of permissions
 * 
 * @Version
 * <br>$Log$
 * <br>Revision 1.4  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-15 09:30:13  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.2  2008-01-08 09:08:13  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */


@NamedQueries
	({
    @NamedQuery(name="getAllRolePermissions", 	query="SELECT OBJECT(o) FROM RolePermission o"),
    @NamedQuery(name="getPermissionsByRole", 	query="SELECT OBJECT(o) FROM RolePermission o, Permission p WHERE o.role.id = :roleid AND p.id = o.permission.id"),
    @NamedQuery(name="getRolesByPermission", 	query="SELECT OBJECT(o) FROM RolePermission o, Role r 		 WHERE o.permission.id = :permissionid AND r.id = o.role.id")
	})

@Entity
@Table(name = "rel_role_permission", schema = "usermanagement")

public class RolePermission extends GECAMedEntityBean implements Serializable 
	{
	private static final long serialVersionUID = 1L;

	private Role		 	m_Role;
	private Permission	m_Permission;
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************	
			
//***************************************************************************
//* Overrrides				                                              *
//***************************************************************************	

//***************************************************************************
//* Getter and Setter Methods	                                              *
//***************************************************************************	

//---------------------------------------------------------------------------
/**
 * Returns the user referenced by this role permission relation 
 * @return Referenced role.
 */
//---------------------------------------------------------------------------

@ManyToOne
@JoinColumn(name = "role_id")

public Role getRole() 
	{
	return m_Role;
	}

//---------------------------------------------------------------------------
/**
 * Sets the role referenced by this role permission relation
 * @param p_Role specifies the new role to be referenced by this relation
 */
//---------------------------------------------------------------------------
	
public void setRole (Role p_Role) 
	{
	m_Role = p_Role;
	}

//---------------------------------------------------------------------------
/**
 * Returns the permission referenced by this role permission relation 
 * @return Referenced permission.
 */
//---------------------------------------------------------------------------

@ManyToOne
@JoinColumn(name = "permission_id")

public Permission getPermission() 
	{
	return m_Permission;
	}

//---------------------------------------------------------------------------
/**
 * Sets the permission referenced by this role permission relation 
 * @param p_Permission specifies the new permission to be referenced by this 
 *        relation
 */
//---------------------------------------------------------------------------

public void setPermission (Permission p_Permission) 
	{
	m_Permission = p_Permission;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
