/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;
import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedLocale;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;

/**
 * Entity Bean that maps the <b>usermanagement.gecamed_user</b> table
 * which stores all gecamed users. The gecamed users is needed for login and right management 
 * in the system. 
 * 
 * @Author Johannes Hermen Tudor/Santec
 *         		Martin Heinemann Tudor/Santec
 *         		Nico Mack Tudor/Santec
 *
 * @Version
 * <br>$Log: GecamedUser.java,v $
 * <br>Revision 1.27  2009-06-02 14:20:47  hermen
 * <br>added search for user/physician
 * <br>
 * <br>Revision 1.26  2009-06-02 12:52:59  hermen
 * <br>added search for user/physician
 * <br>
 * <br>Revision 1.25  2009-03-20 10:20:05  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.24  2009-02-04 10:15:56  hermen
 * <br>added functionality to get all Users that are logged in on a GECAMed Server
 * <br>
 * <br>Revision 1.23  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.22  2008-03-26 10:20:29  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.21  2008-03-25 14:35:29  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.20  2008-01-15 09:30:13  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.19  2008-01-08 09:08:13  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */

    @javax.persistence.NamedQueries({
        
        // findAll NamedQuery
        @javax.persistence.NamedQuery(name="findAllGecamedUsers",
            query="SELECT OBJECT(o) FROM GecamedUser o ORDER BY o.login ASC"),
        // NamedQueries using Fields.
        @javax.persistence.NamedQuery(name="findAllGecamedUsersByName",
            query="SELECT OBJECT(o) FROM GecamedUser o WHERE o.name = :name ORDER BY o.login ASC"),
        @javax.persistence.NamedQuery(name="findAllGecamedUsersByPasswordhash",
            query="SELECT OBJECT(o) FROM GecamedUser o WHERE o.passwordhash = :passwordhash ORDER BY o.login ASC"),
        @NamedQuery(name=GecamedUser.FIND_USERS_BY_LOGIN,
        	query="SELECT OBJECT(o) FROM GecamedUser o WHERE o.login = :login ORDER BY o.login ASC"),
        @NamedQuery(name=GecamedUser.FIND_USER_BY_ID,
        		query="SELECT OBJECT(o) FROM GecamedUser o WHERE o.id = :id ORDER BY o.login ASC")
 })


@javax.persistence.Entity
@javax.persistence.Table(name = "gecamed_user", schema ="usermanagement")
public class GecamedUser extends GECAMedEntityBean implements Serializable {

	private static final long serialVersionUID = 1L;
	
	public static final String FIND_USER_BY_ID = "findGecamedUserById";
	public static final String FIND_USERS_BY_LOGIN = "findGecamedUsersByLogin";
	
	private boolean hasChanges;
	private Date passwordDate;
	private GECAMedLocale gecamedLocale;
	private java.lang.String login;
	private Date lastModification;
	private java.lang.Integer modifiedBy;
	private java.lang.String name;
	private java.lang.String passwordhash;
	private String language;
	private Set<Role> roles;
	private Set <Permission> permissions;
	private Set<Physician> physicians;
	private Integer siteID;
	
	public GecamedUser(){}
	
	public GecamedUser(String name) {
		this.name = name;
	}
	



	/**
	 * Get the lastModification.
	 *
	 * @return The lastModification.
	 */
	@javax.persistence.Column(name = "last_modification")
	public Date getLastModification() {
		return lastModification;
	}

	/**
	 * Set the lastModification.
	 *
	 * @param lastModification The lastModification.
	 */
	public void setLastModification(Date lastModification) {
		this.lastModification = lastModification;
	}



	/**
	 * Get the login name of the user.
	 *
	 * @return The login name of the user.
	 */
	@javax.persistence.Column(name = "login")
	public java.lang.String getLogin() {
		return login;
	}

	/**
	 * Set the login name of the user.
	 *
	 * @param login The login name of the user.
	 */
	public void setLogin(java.lang.String login) {
		this.login = login;
	}



	/**
	 * Get the modifiedBy.
	 *
	 * @return The modifiedBy.
	 */
	@javax.persistence.Column(name = "modified_by")
	public java.lang.Integer getModifiedBy() {
		return modifiedBy;
	}

	/**
	 * Set the modifiedBy.
	 *
	 * @param modifiedBy The modifiedBy.
	 */
	public void setModifiedBy(java.lang.Integer modifiedBy) {
		this.modifiedBy = modifiedBy;
	}



	/**
	 * Get the full name of the user.
	 *
	 * @return The full name of the user.
	 */
	@javax.persistence.Column(name = "name")
	public java.lang.String getName() {
		return name;
	}

	/**
	 * Set the full name of the user.
	 *
	 * @param name The full name of the user.
	 */
	public void setName(java.lang.String name) {
		this.name = name;
	}



	/**
	 * Get the passwordhash.
	 *
	 * @return The passwordhash.
	 */
	@javax.persistence.Column(name = "passwordhash")
	public java.lang.String getPasswordhash() {
		return passwordhash;
	}

	/**
	 * Set the passwordhash.
	 *
	 * @param passwordhash The passwordhash.
	 */
	public void setPasswordhash(java.lang.String passwordhash) {
		this.passwordhash = passwordhash;
	}

    	
	/**
	 * sets the language of the user
	 * @return the language of the user
	 */
	@Column(name = "language")
	public String getLanguage() {
		return this.language;
	}
	
	/**
	 * gets the language of the user
	 * @param language the language of the user
	 */
	public void setLanguage(String language) {
		this.language = language;
	}
	
    
//---------------------------------------------------------------------------
 /** Deprecated Getter and Setter for rights. Getter and Setter methods for
  *  for permission should be used instead
  */
//---------------------------------------------------------------------------
	
	/**
	 * Get the roles in which the user is in.
	 *
	 * @return the roles in which the user is in.
	 */
	@javax.persistence.ManyToMany(fetch = FetchType.EAGER)
	@javax.persistence.JoinTable(name = "rel_user_role", schema = "usermanagement",
							joinColumns = {@javax.persistence.JoinColumn(name = "user_id")},
							inverseJoinColumns = {@javax.persistence.JoinColumn(name = "role_id")})
	public Set<Role> getRoles() {
		return roles;
	}

	/**
	 * Set the roles in which the user is in.
	 *
	 * @param roles the roles in which the user is in.
	 */
	public void setRoles(Set<Role> permissions) {
		this.roles = permissions;
	}
    
//---------------------------------------------------------------------------
    


/**
 * get the users permissions
 * @return the users permissions
 */
@javax.persistence.ManyToMany(fetch = FetchType.EAGER)
@javax.persistence.JoinTable(name = "rel_user_permission", schema = "usermanagement",
						joinColumns = {@javax.persistence.JoinColumn(name = "user_id")},
						inverseJoinColumns = {@javax.persistence.JoinColumn(name = "permission_id")})
public Set<Permission> getPermissions() 
	{
	return permissions;
	}

//---------------------------------------------------------------------------

/**
 * sets the users permissions
 * @param permissions the users permissions
 */
public void setPermissions (Set<Permission> permissions) 
	{
	this.permissions = permissions;
	}

//---------------------------------------------------------------------------

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return this.login + " (" + this.name + ")"; 
    }
    
    
    /**
     * gets the physicians that are mapped to this user
     * @return the physicians that are mapped to this user
     */
    @OneToMany(cascade = {CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH}, fetch = javax.persistence.FetchType.EAGER)
	@JoinColumn(name = "user_id")
	public Set<Physician> getPhysicians() {
		return this.physicians;
	}
    
    /**
     * sets the physicians that are mapped to this user
     * @param physicians the physicians that are mapped to this user
     */
    public void setPhysicians(Set<Physician> physicians) {
    	this.physicians = physicians;
    }

	/**
	 * returns if the user has unsaved the changes.
	 * @return true if the user has unsaved the changes.
	 */
    @Transient
	public boolean hasChanges() {
		return hasChanges;
	}

	/**
	 * sets if the user has unsaved the hasChanges.
	 * @param hasChanges true if the user has unsaved Changes.
	 */
    @Transient
	public void setHasChanges(boolean hasChanges) {
		this.hasChanges = hasChanges;
	}

	/**
	 * returns the date when the users password was set
	 * @return Returns the date when the users password was set
	 */
    @Column(name = "password_date")
	public Date getPasswordDate() {
		return passwordDate;
	}

	/**
	 * sets the date when the users password was set
	 * @param passwordDate the date when the users password was set
	 */
	public void setPasswordDate(Date passwordDate) {
		this.passwordDate = passwordDate;
	}

	/**
	 * returns the users locale as GECAMedLocale
	 * @return the users locale as GECAMedLocale
	 */
    @ManyToOne(fetch = javax.persistence.FetchType.EAGER)
	@JoinColumn(name = "locale_id")
	public GECAMedLocale getGecamedLocale() {
		return gecamedLocale;
	}

	/**
	 * sets the users locale as a GECAMedLocale
	 * @param gecamedLocale the users locale as a GECAMedLocale
	 */
	public void setGecamedLocale(GECAMedLocale gecamedLocale) {
		this.gecamedLocale = gecamedLocale;
	}
    
	/**
	 * Returns all permissions of this user and the inheritated ones from the
	 * user's roles
	 * 
	 * @return
	 */
	@Transient
	public Collection<Permission> getGrantedPermissions() {
		/* ====================================================== */
		Collection<Permission> allP = new ArrayList<Permission>();
		if (this.getRoles() != null)
			for (Role r : this.getRoles())
				if (r.getPermissions() != null ) {
					allP.addAll(r.getPermissions());
				}
		// add the users permissions
		if (this.getPermissions() != null) {
			allP.addAll(this.getPermissions());
		}
		return allP;
		/* ====================================================== */
	}

	/**
	 * @return the siteID
	 */
	@Transient
	public Integer getSiteID() {
	    return siteID;
	}

	/**
	 * @param siteID the siteID to set
	 */
	public void setSiteID(Integer siteID) {
	    this.siteID = siteID;
	}
}


    

