/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Entity Bean that maps the <b>core.info</b> table
 * which stores a informations about all update scripts that have been applied to the db and  
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @Version
 * <br>$Log: GecamedInfo.java,v $
 * <br>Revision 1.7  2009-05-15 07:34:04  hermen
 * <br>show core.info in about dialog
 * <br>
 * <br>Revision 1.6  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-09-24 09:11:52  heinemann
 * <br>added first run actions to gecamed. will disable all views except the ones of the admin tab for user, office and physician.
 * <br>Tabs are enabled, if an physican was saved.
 * <br>
 * <br>Revision 1.4  2008-01-15 09:30:13  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.3  2008-01-08 09:08:13  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
@javax.persistence.NamedQueries({
    @javax.persistence.NamedQuery(name=GecamedInfo.FIND_ALL_INFOS,
	        query="SELECT OBJECT(o) FROM GecamedInfo o ORDER BY o.date, o.id DESC"),
    @javax.persistence.NamedQuery(name=GecamedInfo.FIND_INFOS_BY_KEY,
        query="SELECT OBJECT(o) FROM GecamedInfo o WHERE o.key = :key ORDER BY o.date, o.id DESC"),
    @javax.persistence.NamedQuery(name=GecamedInfo.FIND_LATEST_INFO_BY_KEY,
        query="SELECT OBJECT(o) FROM GecamedInfo o WHERE o.key = :key ORDER BY o.date, o.id DESC LIMIT 1")
})


@javax.persistence.Entity
@javax.persistence.Table(schema = "core", name = "info")
public class GecamedInfo extends GECAMedEntityBean implements Serializable {
    
    private static final long serialVersionUID = 1L;

    public static final String FIND_ALL_INFOS 		= "FIND_ALL_INFOS";
    public static final String FIND_INFOS_BY_KEY 		= "FIND_INFOS_BY_KEY";
    public static final String FIND_LATEST_INFO_BY_KEY  = "FIND_LATEST_INFO_BY_KEY";
    
    public static final String FIRST_RUN = "FIRST_RUN";
    
    
    
    private String key;
    private String value;
    private Date date;
    
    public GecamedInfo() {
        super();
    }

	/**
	 * get timestamp of the db entry
	 * @return the date timestamp of the db entry
	 */
	@javax.persistence.Column(name = "date")
	public Date getDate() {
		return date;
	}

	/**
	 * set timestamp of the db entry
	 * @param date the date to set
	 */
	public void setDate(Date date) {
		this.date = date;
	}

	/**
	 * sets the key of the db entry
	 * @return the key
	 */
	@javax.persistence.Column(name = "key")
	public String getKey() {
		return key;
	}

	/**
	 * gets the key of the db entry
	 * @param key the key to set
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * gets the value of the db entry
	 * @return the value
	 */
	@javax.persistence.Column(name = "value")
	public String getValue() {
		return value;
	}

	/**
	 * sets the value of the db entry
	 * @param value the value to set
	 */
	public void setValue(String value) {
		this.value = value;
	}
	
}
