package lu.tudor.santec.gecamed.reporting.gui.listing;

import java.awt.Color;
import java.awt.Component;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.reporting.ejb.entity.beans.Report;
import lu.tudor.santec.gecamed.reporting.gui.ReportModule;

public class ReportTemplateListRenderer implements ListCellRenderer
{
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private static Icon	icon;
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	public Component getListCellRendererComponent(JList list, Object value, 
			int index, boolean isSelected, boolean cellHasFocus)
	{
		JLabel			label	= new JLabel();
		Report			report;
		Color			bg;
		StringBuilder	text;
		
		// set the text
		if (value instanceof Report)
		{
			report	= (Report) value;
			
			text	= new StringBuilder("<html><font size=\"4\"><b>")
					.append(report.getName())
					.append("</b></font><br/><i><font size=\"2\">")
					.append(report.getType() != null ? report.getType() : "")
					.append("</i></font></html>");
			
			label.setText(text.toString());
			label.setToolTipText(report.getDescription() != null ? report.getDescription() : null);
			label.setIcon(getIcon());
			label.setSize(label.getPreferredSize());
		}
		else if (value != null)
		{
			label.setText(value.toString());
		}
		
		// set the background
		label.setOpaque(true);
		if (isSelected)
			bg	= list.getSelectionBackground();
		else if (index % 2 == 0)
			bg	= GECAMedColors.c_EvenLineBackground;
		else 
			bg	= GECAMedColors.c_OddLineBackground;
		label.setBackground(bg);
		
		return label;
	}
	
	
	private Icon getIcon ()
	{
		if (icon == null)
			icon	= IconFetcher.getScaledIcon(ReportModule.class, "reportmodule.png", 24);
		
		return icon;
	}
}
