package lu.tudor.santec.gecamed.reporting.gui.designer;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.LinkedList;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.core.gui.widgets.LimitTextField;
import lu.tudor.santec.gecamed.core.gui.widgets.NamedComponent;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.reporting.ejb.entity.beans.Report;
import lu.tudor.santec.gecamed.reporting.ejb.entity.beans.ReportParameter;
import lu.tudor.santec.gecamed.reporting.ejb.session.beans.ReportManagerBean;
import lu.tudor.santec.gecamed.reporting.ejb.session.interfaces.ReportManagerInterface;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

public class ReportDesignerDialog extends GECAMedBaseDialogImpl
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private static ReportManagerInterface manager;
	
	private Report			report;
	
	private JTextField		nameField;
	
	private JComboBox		typeBox;
	
	private JTextArea		descriptionArea;
	
	private QueryBuilder	queryBuilder;
	
	private ParameterPanel	parameterPanel;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public ReportDesignerDialog()
	{
		super(MainFrame.getInstance(), 
				Translatrix.getTranslationString("ReportModule.DesignerDialog.title"), 
				GECAMedBaseDialogImpl.OK_CANCEL_BUTTON_MODE);
		
		initComponents();
	}
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	public Report editReport (Report report)
	{
		if (report == null)
		{
			report	= new Report();
			report.setParameter(new LinkedList<ReportParameter>());
		}
		
		setReport(report);
		
		this.pack();
		this.setLocationRelativeTo(getOwner());
		this.setVisible(true);
		
		if (getButtonOption() == OK_OPTION)
			 return getReport();
		else return null;
	}
	
	
	@Override
	public void okActionCalled()
	{
		String	reportName		= this.nameField.getText();
		boolean	reportNameSet	= reportName != null && reportName.length() > 0;
		boolean	paramNamesSet	= this.parameterPanel.allParameterFilledOut();
		
		if (reportNameSet && paramNamesSet)
			// everything OK, close the dialog
			super.okActionCalled();
		else
			// something is wrong, cannot save
			GECAMedBaseDialogImpl.showMessageDialog(
					this, 
					Translatrix.getTranslationString("ReportModule.DesignerDialog.notAllFilledOut_title"), 
					Translatrix.getTranslationString("ReportModule.DesignerDialog.notAllFilledOut_message"), 
					GECAMedBaseDialogImpl.OK_BUTTON_MODE, 
					GECAMedModule.getIcon(GECAMedIconNames.ERROR));
	}
	
	
	
	/* ======================================== */
	// 		HELP METHODS
	/* ======================================== */
	
	private void initComponents ()
	{
		CellConstraints	cc			= new CellConstraints();
		JPanel			mainPanel	= new JPanel(new BorderLayout());
		JSplitPane		splitPane	= new JSplitPane(JSplitPane.VERTICAL_SPLIT);
		JScrollPane		scroller;
		JPanel			panel;
		NamedComponent	namedComponent;
		
		
		panel				= new JPanel(new FormLayout("5px,f:300,5px,f:150,0px:g,5px", 
														"5px,f:p,5px,f:100,5px,f:p,5px"));
		
		this.nameField		= new LimitTextField(100);
		this.typeBox		= new JComboBox();
		this.descriptionArea= new JTextArea();
		
		namedComponent		= new NamedComponent(
				Translatrix.getTranslationString("ReportModule.DesignerDialog.name"), 
				nameField, true, NamedComponent.DIRECTION_HORIZONTAL);
		panel.add(namedComponent, cc.xy(2, 2));
		
		namedComponent		= new NamedComponent(
				Translatrix.getTranslationString("ReportModule.DesignerDialog.type"), 
				typeBox, true, NamedComponent.DIRECTION_HORIZONTAL);
		typeBox.setEditable(true);
		panel.add(namedComponent, cc.xy(4, 2));
		
		scroller			= new JScrollPane(descriptionArea);
		scroller.setOpaque(false);
		scroller.getViewport().setOpaque(false);
		namedComponent		= new NamedComponent(
				Translatrix.getTranslationString("ReportModule.DesignerDialog.description"), 
				scroller, true, NamedComponent.DIRECTION_VERTICAL);
		panel.add(namedComponent, cc.xyw(2, 4, 4));
		
		this.add(panel, BorderLayout.NORTH);
		
		this.queryBuilder	= new QueryBuilder();
		scroller			= new JScrollPane(queryBuilder);
		scroller.setOpaque(false);
		scroller.getViewport().setOpaque(false);
		splitPane.add(scroller,		JSplitPane.TOP);
		
		this.parameterPanel	= new ParameterPanel();
		scroller			= new JScrollPane(parameterPanel);
		scroller.setOpaque(false);
		scroller.getViewport().setOpaque(false);
		splitPane.add(scroller,		JSplitPane.BOTTOM);
		
		splitPane.setPreferredSize(new Dimension(700, 400));
		splitPane.setDividerLocation(150);
		splitPane.setOpaque(false);
		mainPanel.add(splitPane,	BorderLayout.CENTER);
		
		this.add(mainPanel);
	}
	
	
	private void setReport (Report report)
	{
		this.report	= report;
		this.typeBox.setModel(new DefaultComboBoxModel(
				getManager().getAllReportTypes()));
		
		this.nameField.setText(				this.report.getName());
		this.typeBox.setSelectedItem(		this.report.getType());
		this.descriptionArea.setText(		this.report.getDescription());
		this.parameterPanel.setParameter(	this.report.getParameter());
		this.queryBuilder.setQueryString(	this.report.getQuery());
	}
	
	
	private Report getReport ()
	{
		String type	= (String)this.typeBox.getSelectedItem();
		
		this.report.setName(		this.nameField.getText());
		this.report.setType(		type != null ? type : "");
		this.report.setDescription(	this.descriptionArea.getText());
		this.report.setQuery(		this.queryBuilder.getQueryString());
		this.report.setParameter(	this.parameterPanel.getParameter(this.report));
		
		return this.report;
	}
	
	
	private ReportManagerInterface getManager ()
	{
		if (manager == null)
			manager	= (ReportManagerInterface) ManagerFactory.getRemote(ReportManagerBean.class);
		
		return manager;
	}
}
