//package lu.tudor.santec.gecamed.reporting.gui.designer;
//
//import java.awt.Color;
//import java.awt.Component;
//import java.awt.Container;
//import java.awt.Point;
//import java.awt.Window;
//import java.awt.event.ActionEvent;
//import java.awt.event.ActionListener;
//import java.awt.event.MouseEvent;
//import java.awt.event.MouseListener;
//import java.awt.event.MouseMotionListener;
//import java.beans.PropertyChangeEvent;
//import java.beans.PropertyChangeListener;
//import java.text.DateFormat;
//import java.text.ParseException;
//import java.text.SimpleDateFormat;
//import java.util.Calendar;
//import java.util.Date;
//import java.util.GregorianCalendar;
//import java.util.Vector;
//import org.apache.log4j.Level;
//import org.apache.log4j.Logger;
//
//import javax.swing.AbstractAction;
//import javax.swing.BorderFactory;
//import javax.swing.JButton;
//import javax.swing.JComboBox;
//import javax.swing.JComponent;
//import javax.swing.JLabel;
//import javax.swing.JPanel;
//import javax.swing.JSpinner;
//import javax.swing.Popup;
//import javax.swing.PopupFactory;
//import javax.swing.SpinnerNumberModel;
//import javax.swing.SwingUtilities;
//import javax.swing.event.ChangeEvent;
//import javax.swing.event.ChangeListener;
//
//import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
//import lu.tudor.santec.gecamed.core.gui.IconFetcher;
//import lu.tudor.santec.gecamed.formeditor.gui.model.ComboBoxElement;
//import lu.tudor.santec.gecamed.reporting.gui.ReportModule;
//import lu.tudor.santec.i18n.Translatrix;
//
//import com.jgoodies.forms.layout.CellConstraints;
//import com.jgoodies.forms.layout.FormLayout;
//import com.toedter.calendar.JDateChooser;
//
//public class DynamicDateChooser extends JPanel implements ActionListener, MouseListener, MouseMotionListener
//{
//	/* ======================================== */
//	// 		CONSTANTS
//	/* ======================================== */
//	
//	private static final long	serialVersionUID	= 1L;
//	
//	
//	private static final int	FIXDATE			= 0;
//	private static final int	TODAY			= 1;
//	private static final int	FIRST_OF_MONTH	= 2;
//	private static final int	LAST_OF_MONTH	= 3;
//	private static final int	FIRST_OF_YEAR	= 4;
//	private static final int	LAST_OF_YEAR	= 5;
//	
//	private static final String	DIRECTION_PLUS	= "+";
//	private static final String	DIRECTION_MINUS	= "-";
//	
//	Vector<ComboBoxElement<Integer>>	elements	= new Vector<ComboBoxElement<Integer>>(); 
//	
//	private static final ComboBoxElement<Integer>	ELEMENT_FIXDATE			= 
//			new ComboBoxElement<Integer>(
//			Translatrix.getTranslationString("ReportModule.DynamicDateChooser.fixdate"), 
//			FIXDATE);
//	private static final ComboBoxElement<Integer>	ELEMENT_TODAY			= 
//			new ComboBoxElement<Integer>(
//			Translatrix.getTranslationString("ReportModule.DynamicDateChooser.today"), 
//			TODAY);
//	private static final ComboBoxElement<Integer>	ELEMENT_FIRST_OF_MONTH	= 
//			new ComboBoxElement<Integer>(
//			Translatrix.getTranslationString("ReportModule.DynamicDateChooser.firstOfMonth"), 
//			FIRST_OF_MONTH);
//	private static final ComboBoxElement<Integer>	ELEMENT_LAST_OF_MONTH	= 
//			new ComboBoxElement<Integer>(
//			Translatrix.getTranslationString("ReportModule.DynamicDateChooser.lastOfMonth"), 
//			LAST_OF_MONTH);
//	private static final ComboBoxElement<Integer>	ELEMENT_FIRST_OF_YEAR	= 
//			new ComboBoxElement<Integer>(
//			Translatrix.getTranslationString("ReportModule.DynamicDateChooser.firstOfYear"), 
//			FIRST_OF_YEAR);
//	private static final ComboBoxElement<Integer>	ELEMENT_LAST_OF_YEAR	= 
//			new ComboBoxElement<Integer>(
//			Translatrix.getTranslationString("ReportModule.DynamicDateChooser.lastOfYear"),
//			LAST_OF_YEAR);
//	
//	@SuppressWarnings("rawtypes")
//	private static final ComboBoxElement[] 			ORIGIN_ELEMENTS	= new ComboBoxElement[]
//	{ 
//		ELEMENT_FIXDATE, 
//		ELEMENT_TODAY, 
//		ELEMENT_FIRST_OF_MONTH, 
//		ELEMENT_LAST_OF_MONTH, 
//		ELEMENT_FIRST_OF_YEAR, 
//		ELEMENT_LAST_OF_YEAR 
//	};
//	
//	
//	/* ======================================== */
//	// 		MEMBERS
//	/* ======================================== */
//	
//	/** the logger Object for this class */
//	private static Logger 			logger 			= Logger.getLogger(DynamicDateChooser.class.getName());
//	
//	private static DateFormat		dateFormatter	= new SimpleDateFormat("yyyy-MM-dd");
//	
//	private static CellConstraints	cc				= new CellConstraints();
//	
//	private static PopupFactory		popupFactory	= new PopupFactory();
//	
//	
//	private JLabel			currentDateLabel;
//	
//	private JButton			datePanelButton;
//	
//	private JPanel			datePanel;
//	
//	private Popup			popup;
//	
//	private JComboBox		originBox;
//	
//	private JButton			directionButton;
//	
//	private JLabel			dayLabel;
//	
//	private JSpinner		daySpinner;
//	
//	private JSpinner		monthSpinner;
//	
//	private JLabel			monthLabel;
//	
//	private JSpinner		yearSpinner;
//	
//	private JLabel			yearLabel;
//	
//	private JDateChooser	fixDateChooser;
//	
//	private Window			owner;
//	
//	private Point			coordinates;
//	
//	
//	
//	/* ======================================== */
//	// 		CONSTRUCTORS
//	/* ======================================== */
//	
//	public DynamicDateChooser (String phrase)
//	{
//		this();
//		setPhrase(phrase);
//		setCurrentDate(phrase);
//	}
//	
//	public DynamicDateChooser ()
//	{
//		ChangeListener	dateChangeListener;
//		
//		
//		this.setLayout(new FormLayout("32px,f:p:g", "32px"));
//		this.setOpaque(false);
//		
//		currentDateLabel= new JLabel();
//		currentDateLabel.setOpaque(false);
//		this.add(currentDateLabel,	cc.xy(2, 1));
//		
//		datePanelButton	= new JButton(new AbstractAction("",
//				IconFetcher.getIcon(ReportModule.class, "cal.png"))
//		{
//			private static final long	serialVersionUID	= 1L;
//			
//			public void actionPerformed(ActionEvent e)
//			{
//				showPopup();
//			}
//		});
//		this.add(datePanelButton,	cc.xy(1, 1));
//		datePanelButton.addMouseListener(this);
//		
//		dateChangeListener	= new ChangeListener()
//		{
//			public void stateChanged(ChangeEvent e)
//			{
//				setCurrentDate();
//			}
//		};
//		
//		originBox		= new JComboBox(ORIGIN_ELEMENTS);
//		originBox.addActionListener(this);
//		originBox.addMouseListener(this);
//		
//		directionButton	= new JButton(new AbstractAction(DIRECTION_PLUS)
//		{
//			private static final long	serialVersionUID	= 1L;
//
//			public void actionPerformed(ActionEvent e)
//			{
//				switchDirection();
//				setCurrentDate();
//			}
//		});
//		directionButton.addMouseListener(this);
//		
//		dayLabel		= new JLabel(Translatrix.getTranslationString("ReportModule.DynamicDateChooser.day"));
//		daySpinner		= new JSpinner(new SpinnerNumberModel(0, Integer.MIN_VALUE, Integer.MAX_VALUE, 1));
//		daySpinner.addChangeListener(dateChangeListener);
//		daySpinner.addMouseListener(this);
//		
//		monthLabel		= new JLabel(Translatrix.getTranslationString("ReportModule.DynamicDateChooser.month"));
//		monthSpinner	= new JSpinner(new SpinnerNumberModel(0, Integer.MIN_VALUE, Integer.MAX_VALUE, 1));
//		monthSpinner.addChangeListener(dateChangeListener);
//		monthSpinner.addMouseListener(this);
//		
//		yearLabel		= new JLabel(Translatrix.getTranslationString("ReportModule.DynamicDateChooser.year"));
//		yearSpinner		= new JSpinner(new SpinnerNumberModel(0, Integer.MIN_VALUE, Integer.MAX_VALUE, 1));
//		yearSpinner.addChangeListener(dateChangeListener);
//		yearSpinner.addMouseListener(this);
//		
//		fixDateChooser	= new JDateChooser();
//		fixDateChooser.addMouseListener(this);
//		fixDateChooser.addPropertyChangeListener("date", new PropertyChangeListener()
//		{
//			public void propertyChange(PropertyChangeEvent evt)
//			{
//				setCurrentDate();
//			}
//		});
//		
//
//		datePanel		= new JPanel(new FormLayout(
//				// columns
//				"p,2px,42px,2px,50px,2px,50px,2px,50px",
//				// rows
//				"10px,15px"));
//		datePanel.setOpaque(true);
//		datePanel.setBackground(GECAMedColors.c_GECAMedDarkerBackground);
//		datePanel.add(originBox, cc.xywh(1, 1, 1, 2));
//		datePanel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
//		datePanel.addMouseListener(this);
//		
////		datePanel.addMouseListener(this);
////		originBox.addMouseListener(this);
////		fixDateChooser.addMouseListener(this);
////		directionButton.addMouseListener(this);
////		dayLabel.addMouseListener(this);
////		daySpinner.addMouseListener(this);
////		monthLabel.addMouseListener(this);
////		monthSpinner.addMouseListener(this);
////		yearLabel.addMouseListener(this);
////		yearSpinner.addMouseListener(this);
//		
//		activateComponents();
//		
////		popup			= new PopupFactory().getPopup(this, datePanel, x, y);
////		popup.add(datePanel);
////		popup.setOpaque(false);
////		popup.setBackground(GECAMedColors.c_GECAMedDarkerBackground);
//	}
//	
//	
//	
//	/* ======================================== */
//	// 		CLASS BODY
//	/* ======================================== */
//	
//	public static Date phraseToDate (String phrase)
//	{
//		String[]	regions;
//		int			origin;
//		int			direction;
//		int			days;
//		int			month;
//		int			years;
//		Calendar	cal;
//		
//
//		regions	= phrase.split("_");
//		
//		if (regions.length == 1)
//		{
//			// try to make a date out of the phrase
//			try
//			{
//				return	dateFormatter.parse(phrase);
//			}
//			catch (ParseException e)
//			{
//				logger.log(Level.ERROR, e.getMessage(), e);
//				return null;
//			}
//		}
//		else if (regions.length >= 5)
//		{
//			// it's NOT a fix date ...
//			try 
//			{
//				origin		= Integer.parseInt(regions[0]);
//				direction	= DIRECTION_PLUS.equals(regions[1]) ? 1 : -1;
//				days		= Integer.parseInt(regions[2]);
//				month		= Integer.parseInt(regions[3]);
//				years		= Integer.parseInt(regions[4]);
//			}
//			catch (NumberFormatException e)
//			{
//				logger.warn("Unsupported phrase for DynamicDateChooser: \""+phrase+"\"");
//				return null;
//			}
//			
//			cal	= new GregorianCalendar();
//			
//			cal.set(Calendar.HOUR_OF_DAY,	0);
//			cal.set(Calendar.MINUTE,		0);
//			cal.set(Calendar.SECOND,		0);
//			cal.set(Calendar.MILLISECOND,	0);
//			
//			switch (origin)
//			{
//				case FIRST_OF_YEAR:
//					cal.set(Calendar.MONTH,			Calendar.JANUARY);
//				case FIRST_OF_MONTH:
//					cal.set(Calendar.DAY_OF_MONTH,	1);
//					break;
//					
//				case LAST_OF_YEAR:
//					cal.set(Calendar.MONTH,			Calendar.DECEMBER);
//				case LAST_OF_MONTH:
//					cal.set(Calendar.DAY_OF_MONTH,	cal.getActualMaximum(Calendar.DAY_OF_MONTH));
//					break;
//			}
//			
//			cal.add(Calendar.DATE,	direction * days);
//			cal.add(Calendar.MONTH,	direction * month);
//			cal.add(Calendar.YEAR,	direction * years);
//			
//			return cal.getTime();
//		}
//		else 
//		{
//			logger.warn("Unsupported phrase for DynamicDateChooser: \""+phrase+"\"");
//			return null;
//		}
//	}
//	
//	
//	public void actionPerformed (ActionEvent e)
//	{
//		Object	source	= e.getSource();
//		
//		if (source == originBox)
//			activateComponents();
//	}
//	
//	
//	public void mouseExited(MouseEvent e) 
//	{
//		hidePopup((Component) e.getSource(), e.getX(), e.getY());
//	}
//	
//	public void mouseEntered(MouseEvent e) {}
//	
//	public void mouseClicked(MouseEvent e) {}
//	
//	public void mousePressed(MouseEvent e) {}
//	
//	public void mouseReleased(MouseEvent e) {}
//	
//	public void mouseDragged(MouseEvent e) {}
//	
//	public void mouseMoved(MouseEvent e) {}
//	
//	
//	
//	/* ======================================== */
//	// 		GETTER & SETTER
//	/* ======================================== */
//	
//	public String getPhrase ()
//	{
//		int					option;
//		StringBuilder		phrase;
//		
//		
//		option	= getOrigin();
//		
//		if (FIXDATE == option)
//			return dateFormatter.format(fixDateChooser.getDate());
//		
//		phrase	= new StringBuilder(11)
//				.append(option)
//				.append("_")
//				.append(directionButton.getText())
//				.append("_")
//				.append(daySpinner.getValue())
//				.append("_")
//				.append(monthSpinner.getValue())
//				.append("_")
//				.append(yearSpinner.getValue());
//		
//		return phrase.toString();
//	}
//	
//	
//	public void setPhrase (String phrase)
//	{
//		String[]	regions;
//		int			origin;
//		String		direction;
//		int			days;
//		int			month;
//		int			years;
//		Date		fixDate;
//		
//		
//		if (phrase == null)
//			return;
//		
//		regions	= phrase.split("_");
//		
//		if (regions.length == 0)
//		{
//			// it's a fix date
//			try
//			{
//				fixDate	= dateFormatter.parse(phrase);
//				fixDateChooser.setDate(fixDate);
//				originBox.setSelectedItem(ELEMENT_FIXDATE);
//			}
//			catch (ParseException e)
//			{
//				logger.log(Level.ERROR, e.getMessage(), e);
//				return;
//			}
//		}
//		else if (regions.length >= 5)
//		{
//			// it's NOT a fix date ...
//			try 
//			{
//				origin		= Integer.parseInt(regions[0]);
//				direction	= regions[1];
//				days		= Integer.parseInt(regions[2]);
//				month		= Integer.parseInt(regions[3]);
//				years		= Integer.parseInt(regions[4]);
//			}
//			catch (NumberFormatException e)
//			{
//				logger.warn("Unsupported phrase for DynamicDateChooser: \""+phrase+"\"");
//				return;
//			}
//			
//			directionButton.setText(direction);
//			daySpinner.setValue(days);
//			monthSpinner.setValue(month);
//			yearSpinner.setValue(years);
//			originBox.setSelectedIndex(origin);
//		}
//		else 
//		{
//			logger.warn("Unsupported phrase for DynamicDateChooser: \""+phrase+"\"");
//		}
//	}
//	
//	
//	
//	/* ======================================== */
//	// 		HELP METHODS
//	/* ======================================== */
//	
//	private int getOrigin ()
//	{
//		int					option;
//		ComboBoxElement<?>	element;
//		
//		
//		element	= (ComboBoxElement<?>)originBox.getSelectedItem();
//		if (element == null)
//			 option	= -1;
//		else option	= ((Integer)element.getValue()).intValue();
//		
//		return option;
//	}
//	
//	
//	private void showPopup ()
//	{
//		coordinates	= getPopupCoordinates(this);
//		popup	= popupFactory.getPopup(
//				this, 
//				datePanel, 
//				coordinates.x, 
//				coordinates.y);
//		activateComponents();
//		
//		popup.show();
//	}
//	
//
//	private Point getPopupCoordinates (JComponent c)
//	{
//		Point p	= new Point(c.getX(), c.getY() + c.getHeight());
//		
//		return getPopupCoordinates(c, p);
//	}
//	
//	
//	private Point getPopupCoordinates (Container c, Point p)
//	{
//		if (c.getParent() != null && !(c instanceof Window))
//			p	= getPopupCoordinates(c.getParent(), p);
////		else if (this.owner == null && c instanceof Window)
////		{
////			this.owner	= (Window) c;
////			this.owner.addMouseListener(this);
////		}
//		
//		p.x	= p.x + c.getX();
//		p.y	= p.y + c.getY();
//		
//		return p;
//	}
//	
//	
//	private void activateComponents ()
//	{
//		boolean	fixdate		= getOrigin() == FIXDATE;
//		
//		
//		datePanel.remove(fixDateChooser);
//		datePanel.remove(directionButton);
//		datePanel.remove(dayLabel);
//		datePanel.remove(daySpinner);
//		datePanel.remove(monthLabel);
//		datePanel.remove(monthSpinner);
//		datePanel.remove(yearLabel);
//		datePanel.remove(yearSpinner);
//		
//		if (fixdate)
//			datePanel.add(fixDateChooser,	cc.xywh(3, 1, 7, 2));
//		else
//		{
//			datePanel.add(directionButton,	cc.xywh(3, 1, 1, 2));
//			datePanel.add(dayLabel,			cc.xy(5, 1));
//			datePanel.add(daySpinner,		cc.xy(5, 2));
//			datePanel.add(monthLabel,		cc.xy(7, 1));
//			datePanel.add(monthSpinner,		cc.xy(7, 2));
//			datePanel.add(yearLabel,		cc.xy(9, 1));
//			datePanel.add(yearSpinner,		cc.xy(9, 2));
//		}
//		
//		datePanel.setVisible(true);
//		
//		datePanel.validate();
//		datePanel.repaint();
//	}
//
//	
//	private void switchDirection()
//	{
//		directionButton.setText(
//				DIRECTION_PLUS.equals(directionButton.getText()) 
//				? DIRECTION_MINUS : DIRECTION_PLUS);
//	}
//	
//	
//	private void setCurrentDate ()
//	{
//		setCurrentDate(getPhrase());
//	}
//	
//	
//	private void setCurrentDate (String phrase)
//	{
//		Date	date	= phraseToDate(phrase);
//		
//		if (date != null)
//			currentDateLabel.setText(dateFormatter.format(date));
//	}
//	
//	
//	private Window getOwner ()
//	{
//		Container c;
//		
//		if (this.owner == null)
//		{
//			c	= this;
//			while (c != null && !(c instanceof Window))
//				c	= c.getParent();
//			
//			if (c != null)
//				this.owner	= (Window) c;
//		}
//		
//		return owner;
//	}
//	
//	
//	private void hidePopup (Component clickedComponent, int clickedX, int clickedY)
//	{
//		Point	p	= SwingUtilities.convertPoint(clickedComponent, clickedX, clickedY, datePanel);
//		
//		if (popup != null
//				&& (
//				   p.x < 0 
//				|| p.x > datePanel.getWidth()
//				|| p.y < 0
//				|| p.y > datePanel.getHeight()))
//		{
//			popup.hide();
//			getOwner().repaint();
//		}
//	}
//}
