package lu.tudor.santec.gecamed.reporting.gui.creator;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.ErrorDialog;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.reporting.ejb.entity.beans.Report;
import lu.tudor.santec.gecamed.reporting.ejb.entity.beans.ReportParameter.EmptyParameterException;
import lu.tudor.santec.gecamed.reporting.ejb.session.beans.ReportManagerBean;
import lu.tudor.santec.gecamed.reporting.ejb.session.interfaces.ReportManagerInterface;
import lu.tudor.santec.gecamed.reporting.gui.ReportModule;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ReportCreator
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	public static final int	OPTION_SHOW_TABLE		= 0;
	public static final int	OPTION_EXPORT_CSV		= 1;
	public static final int	OPTION_CREATE_IREPORT	= 2;
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private static ReportManagerInterface manager;
	
	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(ReportCreator.class.getName());
	
	
	private ReportTable		table;
	
	private ReportExporter	exporter;
	
	private ReportPrinter	printer;
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	public ReportTable getTable ()
	{
		if (table == null)
			table		= new ReportTable();
		
		return table;
	}
	
	
	public ReportExporter getExporter ()
	{
		if (exporter == null)
			exporter	= new ReportExporter();
		
		return exporter;
	}
	
	
	public ReportPrinter getPrinter ()
	{
		if (printer == null)
			printer		= new ReportPrinter();
		
		return printer;
	}
	
	
	public void createReport (Report report, int option)
	{
		boolean					nativeQuery	= true;
		String					failedQuery;
		StringBuilder 			info;
		
		try
		{
			report	= getManager().getResultList(report);
		}
		catch (EmptyParameterException epe)
		{
			GECAMedBaseDialogImpl.showMessageDialog(
					ReportModule.getInstance()
							.getReportList()
							.getCreatorDialog(), 
					Translatrix.getTranslationString("ReportModule.CreatorDialog.emptyParameterTitle"), 
					Translatrix.getTranslationString("ReportModule.CreatorDialog.emptyParameterMessage",
							new String[] { report.getMendatoryParameterNames() }), 
					GECAMedBaseDialogImpl.OK_BUTTON_MODE, 
					GECAMedModule.getBigIcon(GECAMedIconNames.WARNING));
			
			return;
		}
		catch (Exception e)
		{
			try
			{
				failedQuery	= report.createFilledQuery();
				if (failedQuery == null || failedQuery.length() == 0)
					failedQuery	= report.getQuery();
				
				info = new StringBuilder();
				info.append("\n--------------------------------------------------\n")
						.append("The following ")
						.append(nativeQuery ? "native" : "HSQL")
						.append(" query caused a problem:\n")
						.append(failedQuery.replaceAll("\\<", "&lt;"))
						.append("\n__________________________________________________");
				logger.warn(info.toString());
				logger.log(Level.WARN, e.getMessage(), e);
				
				ErrorDialog.showErrorDialog(MainFrame.getInstance(), "Error executing query", info.toString(), e);
			}
			catch (EmptyParameterException e1)
			{
				logger.log(Level.ERROR, e1.getMessage(), e1);
			}
			return;
		}
		
		if (report.getData() == null || report.getData().isEmpty())
		{
			// query retrieved no results - inform user and don't create a report 
			GECAMedBaseDialogImpl.showMessageDialog(
					ReportModule.getInstance()
							.getReportList()
							.getCreatorDialog(), 
					Translatrix.getTranslationString("ReportModule.ReportTable.noResultTitle"), 
					Translatrix.getTranslationString("ReportModule.ReportTable.noResultMsg"), 
					GECAMedBaseDialogImpl.OK_BUTTON_MODE, 
					GECAMedModule.getMediumIcon(GECAMedIconNames.WARNING));
			return;
		}
		
		if (report.getData() != null)
		{
			switch (option)
			{
				case OPTION_SHOW_TABLE:
					getTable().showTable(report);
					break;
					
				case OPTION_EXPORT_CSV:
					getExporter().export(report);
					break;
					
				case OPTION_CREATE_IREPORT:
					getPrinter().print(report);
					break;
			}
		}
	}
	

	
	/* ======================================== */
	// 		HELP METHODS
	/* ======================================== */
	
	private ReportManagerInterface getManager ()
	{
		if (manager == null)
			manager	= (ReportManagerInterface) ManagerFactory.getRemote(ReportManagerBean.class);
		
		return manager;
	}
	
	
	public static void main(String[] args)
	{
		System.out.println("19841226096".matches("^(19|20)\\d\\d(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01]).*"));
	}
}
