///*******************************************************************************
// * This file is part of GECAMed.
// * 
// * GECAMed is free software: you can redistribute it and/or modify
// * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
// * the Free Software Foundation, either version 3 of the License, or
// * (at your option) any later version.
// * 
// * GECAMed is distributed in the hope that it will be useful,
// * but WITHOUT ANY WARRANTY; without even the implied warranty of
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// * GNU Lesser General Public License for more details.
// * 
// * You should have received a copy of the GNU Lesser General Public License (L-GPL)
// * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
// * 
// * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
// * (c) CRP Henri Tudor, Luxembourg, 2008
// *******************************************************************************/
//package lu.tudor.santec.gecamed.reporting.gui.creator;
//
//import java.awt.BorderLayout;
//import java.awt.GridLayout;
//import java.awt.event.ActionEvent;
//import java.awt.event.ActionListener;
//import java.awt.event.ItemEvent;
//import java.awt.event.ItemListener;
//import java.util.Collection;
//import java.util.HashMap;
//import java.util.Iterator;
//import org.apache.log4j.Level;
//import org.apache.log4j.Logger;
//
//import javax.swing.JButton;
//import javax.swing.JComboBox;
//import javax.swing.JDialog;
//import javax.swing.JPanel;
//import javax.swing.border.TitledBorder;
//
//import lu.tudor.santec.gecamed.core.gui.MainFrame;
//import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
//import lu.tudor.santec.gecamed.reporting.ejb.entity.beans.Report;
//import lu.tudor.santec.gecamed.reporting.ejb.entity.beans.ReportParameter;
//import lu.tudor.santec.gecamed.reporting.ejb.session.beans.ReportManagerBean;
//import lu.tudor.santec.gecamed.reporting.ejb.session.interfaces.ReportManagerInterface;
//import lu.tudor.santec.gecamed.reporting.gui.JRXMLParser;
//import lu.tudor.santec.gecamed.reporting.gui.designer.ParameterPanel;
//import lu.tudor.santec.i18n.Translatrix;
//
//public class ReportChooserDialog extends JDialog
//{
//	
//	private static final long		serialVersionUID	= 1L;
//	
//	/**
//	 * static logger for this class
//	 */
//	private static Logger			logger				= Logger.getLogger(ReportChooserDialog.class.getName());
//	
//	private ReportManagerInterface	manager;
//	private JComboBox				cbReports;
//	protected byte[]				reportBytes;
//	protected ParameterPanel		parameterPanel;
//	private ReportParameter[]		reportParameters;
//	private JButton					startButton;
//	private JButton					cancelButton;
//	protected Report				report;
//	
//	
//	public ReportChooserDialog()
//	{
//		super(MainFrame.getInstance(), Translatrix.getTranslationString("ReportModule.createReport"), true);
//		
//		this.setLayout(new BorderLayout());
//		
//		try
//		{
//			manager = (ReportManagerInterface) ManagerFactory.getRemote(ReportManagerBean.class);
//		}
//		catch (Exception e)
//		{
//			logger.log(Level.WARN, "lookup for ReportManagerBean/remote failed", e);
//		}
//		
//		cbReports = new JComboBox();
//		
//		cbReports.setBorder(new TitledBorder(Translatrix.getTranslationString("ReportModule.selectReport") + ":"));
//		
//		this.add(cbReports, BorderLayout.NORTH);
//		
//		
//		reloadReports();
//		
//		cbReports.addItemListener(new ItemListener()
//		{
//			public void itemStateChanged(ItemEvent e)
//			{
//				if (e.getStateChange() == ItemEvent.SELECTED)
//				{
//					ReportChooserDialog.this.report = (Report) cbReports.getSelectedItem();
//					reportBytes = ReportChooserDialog.this.report.getJrxml();
//					parseJRXML();
//					try
//					{
//						ReportChooserDialog.this.remove(parameterPanel);
//					}
//					catch (Exception ee)
//					{
//					}
//					parameterPanel = new ParameterPanel(reportParameters);
//					ReportChooserDialog.this.add(parameterPanel, BorderLayout.CENTER);
//					ReportChooserDialog.this.validate();
//					parameterPanel.updateUI();
//					ReportChooserDialog.this.pack();
//				}
//			}
//		});
//		
//		try
//		{
//			this.cbReports.setSelectedIndex(0);
//		}
//		catch (Exception e)
//		{
//		}
//		
//		this.startButton = new JButton(Translatrix.getTranslationString("ReportModule.createReport"));
//		this.startButton.addActionListener(new ActionListener()
//		{
//			public void actionPerformed(ActionEvent e)
//			{
//				ReportChooserDialog.this.setVisible(false);
//			}
//		});
//		this.cancelButton = new JButton(Translatrix.getTranslationString("ReportModule.cancel"));
//		this.cancelButton.addActionListener(new ActionListener()
//		{
//			public void actionPerformed(ActionEvent e)
//			{
//				ReportChooserDialog.this.report = null;
//				ReportChooserDialog.this.setVisible(false);
//			}
//		});
//		
//		JPanel jbb = new JPanel(new GridLayout(0, 2));
//		jbb.add(this.cancelButton);
//		jbb.add(this.startButton);
//		
//		this.add(jbb, BorderLayout.SOUTH);
//		
//		this.setSize(300, 600);
//		
//	}
//	
//	
//	public void parseJRXML()
//	{
//		JRXMLParser parser = new JRXMLParser();
//		try
//		{
//			parser.parseFile(reportBytes);
//			reportParameters = parser.getReportParameters();
//		}
//		catch (Exception e)
//		{
//			logger.log(Level.WARN, "parsing report failed", e);
//		}
//	}
//	
//	
//	public Report getReport()
//	{
//		return this.report;
//	}
//	
//	
//	public HashMap getParameterHash()
//	{
//		return parameterPanel.getParameterHashMap();
//	}
//	
//	
//	public void showReportChooser()
//	{
//		reloadReports();
//		MainFrame.showDialogCentered(this);
//	}
//	
//	
//	private void reloadReports()
//	{
//		Collection availableReports;
//		try
//		{
//			cbReports.removeAllItems();
//			availableReports = manager.getAllReports();
//			for (Iterator iter = availableReports.iterator(); iter.hasNext();)
//			{
//				cbReports.addItem(iter.next());
//			}
//		}
//		catch (Exception e1)
//		{
//			logger.log(Level.WARN, "fetching reports failed", e1);
//		}
//	}
//	
//}
