package lu.tudor.santec.gecamed.reporting.gui.creator;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JDialog;
import javax.swing.JScrollPane;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.utils.StringHelper;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.i18n.Translatrix;

import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;

public class FilledQueryDialog extends GECAMedBaseDialogImpl
{
	private static final long	serialVersionUID	= 1L;
	
	
	public FilledQueryDialog(JDialog owner, String sqlQuery)
	{
		super(owner, 
				Translatrix.getTranslationString("ReportModule.CreatorDialog.filledQueryDialog"), 
				OK_BUTTON_MODE);
		
		RSyntaxTextArea	reportQueryArea;
		JScrollPane		reportQueryScroller;
		Dimension		textSize;
		MainFrame		mainFrame	= MainFrame.getInstance();
		
		
		reportQueryArea		= new RSyntaxTextArea();
		reportQueryArea.setSyntaxEditingStyle(SyntaxConstants.SYNTAX_STYLE_SQL);
		reportQueryArea.setEditable(false);
		reportQueryArea.setText(sqlQuery);
		
		textSize			= StringHelper.getTextSize(reportQueryArea);
		if (textSize.height > mainFrame.getHeight() - 100)
			textSize.setSize(textSize.width + 20, mainFrame.getHeight() - 100);
		if (textSize.width > mainFrame.getWidth() - 50)
			textSize.setSize(mainFrame.getWidth() - 50, textSize.height);
		
		reportQueryScroller	= new JScrollPane(reportQueryArea);
		reportQueryScroller.setOpaque(false);
		reportQueryScroller.getViewport().setOpaque(false);
//		reportQueryScroller.setPreferredSize(new Dimension(220, 150));
		reportQueryScroller.setPreferredSize(textSize);
		this.mainPanel.setLayout(new BorderLayout());
		this.mainPanel.add(reportQueryScroller, BorderLayout.CENTER);
		
//		this.setSize(StringHelper.getTextSize(reportQueryArea));
		this.pack();
		this.setLocationRelativeTo(getOwner());
	}
}
