/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.reporting.ejb.session.interfaces;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

import javax.annotation.security.RolesAllowed;

import lu.tudor.santec.gecamed.reporting.ejb.entity.beans.ParameterQuery;
import lu.tudor.santec.gecamed.reporting.ejb.entity.beans.Report;
import net.sf.jasperreports.engine.JasperPrint;

public interface ReportManagerInterface {

	@RolesAllowed("gecam")
    public JasperPrint createReport(Integer reportID, HashMap<String, Object> parameters) throws Exception;
	
	public Report saveReport(Report report);
	
	public boolean deleteReport (Report report);
	
	public Collection<Report> getAllReports() throws Exception;
	
//	public Collection<Report> getAllReportsByModule(String type) throws Exception;
	
	public Report getReportByName(String name) throws Exception;
	
	public Object[] getAllReportTypes ();
	
	public HashSet<String> getAllReportNames ();
	
	public Report getResultList (Report report) throws Exception;
	
	public List<ParameterQuery> getAllParameterQueries ();
	
	public ParameterQuery getParameterQuery (Integer id);
	
	public List<?> getParameterOptions (String query);
}
