/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 *
 */
package lu.tudor.santec.gecamed.prescription.gui.widgets.toolkit.searchbox;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;

import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.ModuleHeader;
import lu.tudor.santec.gecamed.prescription.ejb.entity.dataclasses.DrugLight;
import lu.tudor.santec.gecamed.prescription.gui.PrescriptionIcons;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * A window to select the form of a drug.
 * It may can happen that a drugs have the same name but different form.
 * pills and liquid for example.
 *
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: DrugFormSelector.java,v $
 * <br>Revision 1.5  2010-03-30 10:31:14  troth
 * <br>Redesign of the prescription view - add Icons
 * <br>
 * <br>Revision 1.4  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-16 15:33:35  heinemann
 * <br>better documentation
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:39  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.1  2007/02/08 16:45:12  heinemann
 * <br>many changes
 * <br>
 */
public class DrugFormSelector extends JDialog implements KeyListener, MouseListener{

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;
	private ModuleHeader titlePanel;
	private JList list;
	private DefaultListModel listModel;
	private DrugLight returnDrug;


	/**
	 *
	 */
	public DrugFormSelector(Frame frame) {
		/* ====================================================== */
		super(frame, true);
		initComponent();
		/* ====================================================== */
	}


	/**
	 * Show the dialog and return the selection.
	 * If escape is pressed, null will be returned
	 *
	 * @param drugs the drugs to select
	 * @return the selected drug, or null if aborted
	 */
	public DrugLight showDialog(List<DrugLight> drugs) {
		/* ====================================================== */
		// remove all elements
		this.listModel.clear();
		/* ------------------------------------------------------- */
		if (drugs == null || drugs.size() == 0)
			return null;
		/* ------------------------------------------------------- */
		// set the data
		for (DrugLight d : drugs)
			listModel.addElement(d);

		// select the first one
		list.setSelectedIndex(0);

		this.pack();
		list.requestFocus();
		MainFrame.showDialogCentered(this);



		return this.returnDrug;
		/* ====================================================== */
	}


	/**
	 * init components
	 */
	private void initComponent() {
		/* ====================================================== */
		this.setLayout(new FormLayout(
				// cols
				"3dlu,fill:pref,3dlu",
				// rows
				"3dlu, fill:pref, 3dlu, fill:pref:grow, 3dlu"));
		CellConstraints cc = new CellConstraints();
		/* ------------------------------------------------------- */
		/* ------------------------------------------------------ */
		// the header
		this.titlePanel = new ModuleHeader(
				Translatrix.getTranslationString("prescription.help.selectDrugForm"),
				PrescriptionIcons.getIcon(PrescriptionIcons.INFORMATION),
				new Color(133, 190, 255));
		this.add(titlePanel, cc.xy(2, 2));
		/* ------------------------------------------------------ */
		// the list
		this.list = new JList();
		/* ------------------------------------------------------- */
		this.listModel = new DefaultListModel();
		list.setModel(listModel);
		/* ------------------------------------------------------- */
		list.setCellRenderer(new DrugFormListRenderer());
		/* ------------------------------------------------------- */
		JScrollPane scroll = new JScrollPane(list);

		this.add(scroll, cc.xy(2, 4));


		list.addKeyListener(this);
		list.addMouseListener(this);

		/* ====================================================== */
	}


	class DrugFormListRenderer extends DefaultListCellRenderer {

		/**
		 *
		 */
		private static final long serialVersionUID = 1L;

		@Override
		public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
			/* ================================================== */
			if (value != null) {
				if (value instanceof DrugLight) {
					/* ------------------------------------------------------- */
					return super.getListCellRendererComponent(list, ((DrugLight) value).getForm(), index, isSelected,
							cellHasFocus);
					/* ------------------------------------------------------- */
				}
			}
			return super.getListCellRendererComponent(list, value, index, isSelected,
					cellHasFocus);
			/* ================================================== */
		}

	}


	public void keyPressed(KeyEvent e) {
		keyAction(e);
	}


	public void keyReleased(KeyEvent e) {
//		keyAction(e);

	}


	public void keyTyped(KeyEvent e) {
		keyAction(e);

	}

	private void keyAction(KeyEvent e) {
		/* ================================================== */
		if (e.getComponent() instanceof JList)
		if (e.getKeyCode() == KeyEvent.VK_ENTER) {
			/* ------------------------------------------------------- */
			// select the drug
			this.returnDrug = (DrugLight) this.list.getSelectedValue();
			// close
			this.setVisible(false);
			/* ------------------------------------------------------- */
		} else if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
			/* ------------------------------------------------------- */
			// set selection to null
			this.returnDrug = null;
			// close
			this.setVisible(false);
			/* ------------------------------------------------------- */
		}
		/* ================================================== */
	}


	public void mouseClicked(MouseEvent e) {
		if (e.getClickCount() == 2) {
			this.returnDrug = (DrugLight) list.getSelectedValue();
			this.setVisible(false);
		}
	}


	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}
	public void mousePressed(MouseEvent e) {
		// TODO Auto-generated method stub

	}


}
