/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 *
 */
package lu.tudor.santec.gecamed.prescription.gui.widgets.toolkit.searchbox;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JList;

import lu.tudor.santec.gecamed.prescription.ejb.entity.dataclasses.DrugLight;

/**
 * The DefaultRenderer for the SearchBox.
 * It uses Drug as default data objects
 * and displays the Cefip name of the drug.
 * If you wish to use it for other stuff, just overwrite it
 * or implement your own renderer.
 * The interface ISearchBoxDataRenderer must be implemented
 *
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: DefaultSearchBoxRenderer.java,v $
 * <br>Revision 1.7  2008-11-04 08:55:13  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.6  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-01-16 15:33:35  heinemann
 * <br>better documentation
 * <br>
 * <br>Revision 1.4  2007/03/02 08:28:39  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.3.2.2  2007/02/08 16:45:12  heinemann
 * <br>many changes
 * <br>
 * <br>Revision 1.3.2.1  2007/01/04 13:51:37  heinemann
 * <br>The great space cleaning lady has done a big bunch of refactoring
 * <br>
 * <br>Revision 1.3  2006/09/07 13:35:38  heinemann
 * <br>many changes
 * <br>
 *
 */
public class DefaultSearchBoxRenderer extends JLabel implements ISearchBoxDataRenderer {

    private static final long serialVersionUID = 1L;

    public DefaultSearchBoxRenderer() {
        super();
    }


    /* (non-Javadoc)
     * @see lu.tudor.santec.gecamed.prescription.gui.widgets.toolkit.searchbox.ISearchBoxDataRenderer#getRelevantData(java.lang.Object)
     */
    public String getRelevantData(Object o) {
    	return null;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {

        if (value instanceof DrugLight) {

            String s = ((DrugLight)value).getName();
            setText(s);
            setName("searchListItem"+index);

              if (isSelected) {
                setBackground(list.getSelectionBackground());
                  setForeground(list.getSelectionForeground());
              }
            else {
                  setBackground(list.getBackground());
                  setForeground(list.getForeground());
              }
              setEnabled(list.isEnabled());
              setFont(list.getFont());
            setOpaque(true);
            return this;
        } else {
            this.setText(value.toString());
            return this;
        }


    }

    public String getStringForTextField(Object data) {
        // the data object should be an MainDrug
//        if (data instanceof Drug) {
//            return ((Drug) data).getName();
//        }
//        else
    	if (data == null)
    		return "";
    	else
            return data.toString();
    }

}




