/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 *
 */
package lu.tudor.santec.gecamed.prescription.gui.widgets.editor.template;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

import lu.tudor.santec.gecamed.core.gui.utils.filtertablemodel.FilterTableModel;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.PrescriptionTemplate;
import lu.tudor.santec.i18n.Translatrix;

/**
 *
 * The model for the list/table of prescription templates.
 *
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: TemplateModel.java,v $
 * <br>Revision 1.11  2013-12-27 18:09:25  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.10  2008-10-22 15:46:34  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.9  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.8  2008-05-13 11:53:41  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.7  2008-02-08 14:47:38  mack
 * <br>Changes required by moving filtertablemodel into dedicated sub-package
 * <br>
 * <br>Revision 1.6  2008-01-15 13:40:35  heinemann
 * <br>better documentation
 * <br>
 * <br>Revision 1.5  2007/03/30 12:18:00  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2007/03/14 09:07:36  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2007/03/12 14:33:58  heinemann
 * <br>Incomplete - # 5: Implement the filter function for the prescription templates
 * <br>http://santec.tudor.lu:8888/gecamed/ticket/5
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:39  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.6  2007/01/24 12:48:56  heinemann
 * <br>consultation and prescription update control.
 * <br>Modifications are displayed.
 * <br>And Incidents are not created if nothing has been entered in consultation, accident and prescription
 * <br>
 * <br>Revision 1.1.2.5  2007/01/04 13:51:37  heinemann
 * <br>The great space cleaning lady has done a big bunch of refactoring
 * <br>
 * <br>Revision 1.1.2.4  2006/12/28 10:32:26  heinemann
 * <br>bug fixing and template improvements
 * <br>
 * <br>Revision 1.1.2.3  2006/12/21 14:26:43  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1.2.2  2006/12/15 15:59:11  heinemann
 * <br>presc
 * <br>
 * <br>Revision 1.1.2.1  2006/12/14 09:34:01  heinemann
 * <br>many changes
 * <br>
 */
public class TemplateModel extends FilterTableModel {

	/* *************************************************************
	 *  Class members
	 */

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;


	private HashMap<String, Vector<PrescriptionTemplate>> templates = new HashMap<String, Vector<PrescriptionTemplate>>();


	private String prescriptionType;


	private TemplateControler controler;


//	private List<PrescriptionTemplate> markedTemplates = new ArrayList<PrescriptionTemplate>();


	/* ------------------------------------------------------------
	 *  End of Classmembers
	 * ************************************************************ */

	/**
	 * @param controler
	 */
	public TemplateModel(TemplateControler controler)  {
		/* ====================================================== */
		this.controler = controler;
		/* ====================================================== */
	}



	/**
	 * Switch the prescription type
	 *
	 * @param type
	 */
	public void switchType(String type) {
		/* ====================================================== */
		this.prescriptionType = type;
//		this.setFilteringEnabled(false, 0);
		this.setTableData(templates.get(prescriptionType));
//		this.update();
		this.fireTableDataChanged();
		/* ====================================================== */
	}


	/**
	 * Set the template data for a type
	 *
	 * @param prescriptionType
	 * @param templates
	 */
	public void setData(String prescriptionType, List<PrescriptionTemplate> temp) {
		/* ====================================================== */
		templates.remove(prescriptionType);

		// add the new data
		templates.put(prescriptionType, new Vector<PrescriptionTemplate>(temp));
		switchType(prescriptionType);
		/* ====================================================== */
	}


	/**
	 * Set the filtertext
	 *
	 * @param text
	 */
	protected int setFilterText(String text) {
		/* ====================================================== */
		// find the row matching to this text
		for (int i = 0; i < this.getRowCount(); i++) {
			/* ------------------------------------------------------ */
			String s = (String) getValueAt(i, 0);
			if (s.startsWith(text))
				return i;
			/* ------------------------------------------------------ */
		}
		return -1;
		/* ====================================================== */
	}


	/**
	 * Returns a PrescriptionTemplate object that
	 * is coresponding to the selected row
	 *
	 * @param row
	 * @return
	 */
	protected PrescriptionTemplate getTemplateByRow(int rowIndex) {
		/* ====================================================== */
		try {
//			this.setTableData(templates.get(prescriptionType));
			int row = 0;
			if (this.isFiltering())
				row = this.filteredToModel(rowIndex);
			else
				row = rowIndex;

			return templates.get(this.prescriptionType).get(row);
		} catch (Exception e) {
			return null;
		}
		/* ====================================================== */
	}



	/* *************************************************************
	 * Inherited methods from DefaultTableModel
	 *
	 */

	/* (non-Javadoc)
	 * @see javax.swing.table.DefaultTableModel#getColumnCount()
	 */
//	@Override
	public int getColumnCount() {
		/* ============================================= */
		return 2;
		/* ============================================= */
	}

	/* (non-Javadoc)
	 * @see javax.swing.table.DefaultTableModel#getColumnName(int)
	 */
	@Override
	public String getColumnName(int column) {
		/* ============================================= */
		if (column == 0) {
			return Translatrix.getTranslationString("template.table.shortcut");
		} else if (column == 1)
			return Translatrix.getTranslationString("template.table.name");
		else
			return "";
		/* ============================================= */
	}

	/* (non-Javadoc)
	 * @see javax.swing.table.DefaultTableModel#getRowCount()
	 */
//	@Override
	public int getRowCount() {
		/* ============================================= */
//		try {
//			return templates.get(this.prescriptionType).size();
//		} catch (Exception e) {
//			return 0;
//		}
//		if (templates.get(prescriptionType) != null) {
//			if (this.isFiltering())
		try {
		if (this.templates.get(prescriptionType).size() > 0)
			return this.getFilteredRowCount();
		} catch (Exception e) {
		}

		return 0;
//		}
//		else
//			return this.templates.get(prescriptionType).size();
//		this.setFilteringEnabled(true, 0);
//		this.update();
//		if (this.isFiltering())
//		else
//			if(templates.get(prescriptionType) != null)
//			return this.templates.get(prescriptionType).size();
//		else
//			return 0;
		/* ============================================= */
	}

	/* (non-Javadoc)
	 * @see javax.swing.table.DefaultTableModel#getValueAt(int, int)
	 */
//	@Override
	public Object getValueAt(int row, int column) {
		/* ============================================= */
//		this.setTableData(templates.get(prescriptionType));
//		this.update();
		try {
			int fRow = 0;
			if (this.isFiltering())
				fRow = this.filteredToModel(row);
			else
				fRow = row;
			/* ------------------------------------------------------- */
			if (column == 0) {
				/* ------------------------------------------------------ */
				// return shortcut
				return templates.get(this.prescriptionType).get(fRow).getShortcut();
				/* ------------------------------------------------------ */
			} else
				if (column == 1) {
					/* ------------------------------------------------------ */
					// return description
					return templates.get(this.prescriptionType).get(fRow).getDescription();
					/* ------------------------------------------------------ */
				}
				else
					return null;
		}
		catch (Exception e) {
			return "";
		}

		/* ============================================= */
	}

	/* (non-Javadoc)
	 * @see javax.swing.table.DefaultTableModel#isCellEditable(int, int)
	 */
	@Override
	public boolean isCellEditable(int row, int column) {
		/* ============================================= */
		return false;
		/* ============================================= */
	}


//
//	public void markAsDeleted(PrescriptionTemplate t) {
//		/* ============================================= */
//		this.markedTemplates.add(t);
//		/* ============================================= */
//	}
//
//	public void unmarkDeleted(PrescriptionTemplate t) {
//		/* ====================================================== */
//		this.markedTemplates.remove(t);
//		/* ====================================================== */
//	}



//	/**
//	 * returns true if the template is marked for delete
//	 *
//	 * @param template
//	 * @return
//	 */
//	public boolean isMarked(PrescriptionTemplate template) {
//		/* ============================================= */
//		return markedTemplates.contains(template);
//		/* ============================================= */
//	}
//
//
//
//	/**
//	 * Delete the marked templates
//	 */
//	public void deleteMarkedTemplates() {
//		/* ============================================= */
//		controler.getManager().deleteTemplates(this.markedTemplates);
//
//		markedTemplates.clear();
//		fireTableDataChanged();
//		/* ============================================= */
//	}
//	
	
	public void deleteTemplate(PrescriptionTemplate template) {
		/* ================================================== */
		controler.getManager().deleteTemplates(Collections.singletonList(template));
		fireTableDataChanged();
		/* ================================================== */
	}
	
	/* --------------------------------------------------------------
	 * End of inherited Methods
	 * ***************************************************************/

}


