/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.prescription.gui.widgets.editor;

import java.awt.Color;
import java.awt.Component;

import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

import lu.tudor.santec.gecamed.core.gui.utils.LineColorCellRenderer;
import lu.tudor.santec.gecamed.prescription.ejb.entity.dataclasses.DrugLight;
import lu.tudor.santec.i18n.Translatrix;

/**
 * Renderer for the table in the prescription editor.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 15.01.2008
 * 13:13:59
 *
 *
 * @version
 * <br>$Log: DrugCellRenderer.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:08  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-15 13:40:47  heinemann
 * <br>better documentation
 * <br>
 *   
 */
public class DrugCellRenderer extends JEditorPane implements TableCellRenderer {

	// ***************************************************************************
	// * Class Constants *
	// ***************************************************************************

	private static final long serialVersionUID = 1L;
	private static final int c_Gap = 2;
	private static final LineColorCellRenderer shortcutRenderer = new LineColorCellRenderer();
	private final static int fontSize = 9;

	/**
	 * 
	 */
	public DrugCellRenderer() {
		setContentType("text/html");
		this.setBorder(BorderFactory.createEmptyBorder(c_Gap, c_Gap, c_Gap,
				c_Gap));
	}

	public Component getTableCellRendererComponent(JTable p_Table,
			Object value, boolean p_IsSelected, boolean hasFocus, int row,
			int column) {
		if (column == 0) {
			/* ------------------------------------------------------ */

			if (row % 2 == 0) {
				String text = "";
				if (value instanceof DrugLight && ((DrugLight) value).getName() != null
							&& !"".equals(((DrugLight) value).getName())) {
					/* ------------------------------------------------------- */
					DrugLight dl = (DrugLight) value;
					text = "<html><b>" + dl.getName() +
					(dl.getForm() != null && !"".equals(dl.getForm())
							? " " + dl.getForm()
							: "");
					/* ------------------------------------------------------- */
				}
//					else text = "<html><b>"+(String) value;
				else text = "";

				if (value == null || text.equals(""))
					text = "<"
							+ Translatrix
									.getTranslationString("prescription.name.drug.enterDrug")
							+ ">";
				return shortcutRenderer.getTableCellRendererComponent(p_Table,
						text, p_IsSelected, hasFocus, row, column);
			}

			if (value != null && !value.equals(""))
				setText("<html><span style=\"font-family:Arial;font-size:"
						+ fontSize + "px;\">"
						+ ((String) value).replaceAll("\n", "<br>"));
			else
				setText("<html><span style=\"font-family:Arial;font-size:"
						+ fontSize
						+ "px;\">&lt;"
						+ Translatrix
								.getTranslationString("prescription.name.drug.enterPosology")
						+ "&gt;");

			setSize(p_Table.getColumnModel().getColumn(column).getWidth(),
					getPreferredSize().height);

			if (p_Table.getRowHeight(row) < getPreferredSize().height) {
				p_Table.setRowHeight(row, getPreferredSize().height);
			}

			if (p_IsSelected)
				this.setBackground(p_Table.getSelectionBackground());
			else
				this.setBackground(Color.WHITE);
			return this;

			/* ------------------------------------------------------ */
		}
		else if (column == 1) {
			/* ------------------------------------------------------ */
			// the icons for cefip browser and posology chooser
			if (row % 2 == 0) {
				/* ------------------------------------------------------ */
				/* ------------------------------------------------------ */
			}

			return this;
			/* ------------------------------------------------------ */
		}
		else
			return this;
	}
}
