/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: DrugDataGrabber.java,v $
 * <br>Revision 1.4  2013-07-15 06:18:37  ferring
 * <br>logging changed
 * <br>
 * <br>Revision 1.3  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:42  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.1  2007/02/21 10:01:01  heinemann
 * <br>*** empty log message ***
 * <br>
 *
 */
package lu.tudor.santec.gecamed.prescription.gui.widgets.drugbrowser;

import java.util.ArrayList;
import java.util.List;

import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.IDrug;
import lu.tudor.santec.gecamed.prescription.gui.util.IResultListener;
import lu.tudor.santec.gecamed.prescription.gui.util.NewDrugWorker;

/**
 * Threaded class that grabs all drugs that are available in the
 * database.
 * It runs with lowest Thread-Level.
 *
 * @author martin.heinemann@tudor.lu
 * 09.02.2007
 * 15:59:00
 *
 *
 * @version
 * <br>$Log: DrugDataGrabber.java,v $
 * <br>Revision 1.4  2013-07-15 06:18:37  ferring
 * <br>logging changed
 * <br>
 * <br>Revision 1.3  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:42  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.1  2007/02/21 10:01:01  heinemann
 * <br>*** empty log message ***
 * <br>
 *
 */
public class DrugDataGrabber extends Thread {


	/* ************************************************************
	 * Class members
	 */

	private List<IResultListener> resultListeners;

	private final int PAGE_SIZE = 20200;
	private int position = 0;

	/* ------------------------------------------------------- */

	/**
	 *
	 */
	public DrugDataGrabber() {
		/* ================================================== */
		resultListeners = new ArrayList<IResultListener>();
		this.setPriority(Thread.MIN_PRIORITY);
		/* ================================================== */
	}


	/* (non-Javadoc)
	 * @see java.lang.Thread#run()
	 */
	public void run() {
		/* ================================================== */
		while(true) {
			/* ------------------------------------------------------- */
			List<IDrug> temp = NewDrugWorker.getAllDrugs(position, PAGE_SIZE);
			// if there are no results, quit
			if (temp.size() == 0)
				return;
			/* ------------------------------------------------------- */
			informResultListener(temp);
			position = position + PAGE_SIZE;
			/* ------------------------------------------------------- */
			// pause the thread;
			Thread.yield();
		}
		/* ================================================== */
	}


	/**
	 * Sends the result to the listeners
	 *
	 * @param data
	 */
	private void informResultListener(Object data) {
		/* ================================================== */
		for (IResultListener r : resultListeners)
			r.receiveResult(data);
		/* ================================================== */
	}


	/**
	 * Add result listener
	 *
	 * @param listener
	 */
	public void addResultListener(IResultListener listener) {
		/* ================================================== */
		this.resultListeners.add(listener);
		/* ================================================== */
	}


}



