/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/

package lu.tudor.santec.gecamed.prescription.gui.widgets.drugbrowser;

import static lu.tudor.santec.gecamed.prescription.gui.widgets.drugbrowser.DrugBrowserModel.HEADER_DOSE;
import static lu.tudor.santec.gecamed.prescription.gui.widgets.drugbrowser.DrugBrowserModel.HEADER_FORM;
import static lu.tudor.santec.gecamed.prescription.gui.widgets.drugbrowser.DrugBrowserModel.HEADER_MANUFACTURER;
import static lu.tudor.santec.gecamed.prescription.gui.widgets.drugbrowser.DrugBrowserModel.HEADER_NAME;
import static lu.tudor.santec.gecamed.prescription.gui.widgets.drugbrowser.DrugBrowserModel.HEADER_PACKAGE;
import static lu.tudor.santec.gecamed.prescription.gui.widgets.drugbrowser.DrugBrowserModel.HEADER_PRICE;
import static lu.tudor.santec.gecamed.prescription.gui.widgets.drugbrowser.DrugBrowserModel.HEADER_SUBSTANCE;
import static lu.tudor.santec.gecamed.prescription.gui.widgets.drugbrowser.DrugBrowserModel.getRowForName;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import lu.tudor.santec.gecamed.core.gui.GECAMedAction;
import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedLog;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.utils.WindowToolbox;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialog;
import lu.tudor.santec.gecamed.core.gui.widgets.NamedComponent;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.AtcClass;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.IDrug;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.IManufacturer;
import lu.tudor.santec.gecamed.prescription.gui.util.NewDrugWorker;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.widgets.gui.ButtonFactory;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;



/**
 * The DrugBrowser is a window that contains a list of all drugs that are in the database.
 * I shows all properties that are default in the IDrug interface. There are some possibilities to
 * sort and search the list by name, substance and atc class.
 * The DB is built as a dialog. You can open it by seningg a search string representing a name
 * of a drug.
 * The selected drug is the return value of the show method.
 * 
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 13.02.2007
 * 09:08:51
 *
 *
 * @version
 * <br>$Log: DrugBrowser.java,v $
 * <br>Revision 1.20  2013-03-22 10:28:58  ferring
 * <br>store position and size of the dialog by user
 * <br>
 * <br>Revision 1.19  2010-10-20 14:26:26  troth
 * <br>remove system.out.println
 * <br>
 * <br>Revision 1.18  2010-06-17 12:32:42  troth
 * <br>small bug fix - # 535: Problem bei Medikamenten�bernahme aus CEFIP
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/535
 * <br>
 * <br>Revision 1.17  2010-04-27 11:37:34  troth
 * <br>add logger for CEFIP prescribed
 * <br>
 * <br>Revision 1.16  2010-03-25 16:03:58  troth
 * <br>Redesign of the prescription view - DrugBrowser extends now from GECAMedBaseDialog
 * <br>
 * <br>Revision 1.15  2010-03-12 14:17:42  hermen
 * <br>cleanup of panel layouts and icons
 * <br>
 * <br>Revision 1.14  2009-04-15 13:30:41  heinemann
 * <br>added cefip and posology button to template editor
 * <br>
 * <br>Revision 1.13  2009-04-15 11:29:54  heinemann
 * <br>removed atc column, obsolete
 * <br>
 * <br>Revision 1.12  2009-04-15 09:55:17  heinemann
 * <br>currency is displayd in euro
 * <br>
 * <br>Revision 1.11  2008-12-17 15:23:06  heinemann
 * <br>initial commit after merging of branch new prescription
 * <br>
 * <br>Revision 1.10.2.1  2008-12-15 14:08:20  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.10  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.9  2008-01-15 13:40:47  heinemann
 * <br>better documentation
 * <br>
 * <br>Revision 1.8  2007/08/01 07:09:00  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.6  2007/07/03 12:35:29  heinemann
 * <br>system.out removed
 * <br>
 * <br>Revision 1.5  2007/03/12 14:33:58  heinemann
 * <br>Incomplete - # 5: Implement the filter function for the prescription templates
 * <br>http://santec.tudor.lu:8888/gecamed/ticket/5
 * <br>
 * <br>Revision 1.4  2007/03/07 09:45:05  heinemann
 * <br>bug fixes
 * <br>
 * <br>Revision 1.3  2007/03/06 13:33:18  heinemann
 * <br>Incomplete - # 4: Integrate a CEFIP Browser for the prescription part
 * <br>http://santec.tudor.lu:8888/gecamed/ticket/4
 * <br>
 * <br>add clear button
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:42  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.2  2007/02/28 08:32:54  heinemann
 * <br>added m2n for billing templates and rates
 * <br>
 * <br>Revision 1.1.2.1  2007/02/21 10:01:01  heinemann
 * <br>*** empty log message ***
 * <br>
 *
 */
public class DrugBrowser extends GECAMedBaseDialog implements DocumentListener, MouseListener, KeyListener {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private static DrugBrowser drugBrowser = new DrugBrowser();

	private JTable table;
	private DrugBrowserModel drugBrowserModel;
	private JPanel tablePanel;
	private GECAMedAction okAction;
	protected IDrug selectedDrug;
	private GECAMedAction cancelAction;
	private JPanel searchPanel;
	private JTextField nameTextField;
	private JTextField substanceTextField;
	private JTextField atcTextField;
	private CellConstraints cc;
	private NameFilter drugNameFilter;
	private NameFilter drugSubstanceFilter;
	private JButton clearButton;
	private AtcFilter atcFilter;

	private DrugBrowserRenderer drugBrowserRenderer;

	private GECAMedAction clearAction;

	private JDialog showingDialog;

	private static final int w80 = 80;
//	private static final int w150 = 150;
	private static final int W200 = 200;
	private static final int w250 = 200; 
	private static final int w300 = 300;

	protected static final String CEFIP_PRESCRIBED = "PRESC:CEFIP";
	
	/**
	 *
	 */
	private DrugBrowser() {
		/* ================================================== */
		//super(MainFrame.getInstance(),true);
		super(Translatrix.getTranslationString("prescription.name.drugbrowser"), true, true);
		setResizingOptions(RESIZING_ALL);
		/* ------------------------------------------------------- */
		this.initComponent();
		initButtonActions();
		/* ------------------------------------------------------- */
		this.drugNameFilter 		= new NameFilter();
		this.drugSubstanceFilter 	= new NameFilter();
		this.atcFilter 				= new AtcFilter();
		/* ------------------------------------------------------- */
		// install filters
		drugBrowserModel.installFilter(drugNameFilter, 		getRowForName(HEADER_NAME));
		drugBrowserModel.installFilter(drugSubstanceFilter, getRowForName(HEADER_SUBSTANCE));
//		drugBrowserModel.installFilter(atcFilter, 			getRowForName(HEADER_ATC));
		/* ------------------------------------------------------- */
		// enable filters
		drugBrowserModel.setFilteringEnabled(true, getRowForName(HEADER_NAME));
		drugBrowserModel.setFilteringEnabled(true, getRowForName(HEADER_SUBSTANCE));
//		drugBrowserModel.setFilteringEnabled(true, getRowForName(HEADER_ATC));
		/* ------------------------------------------------------- */
		initTableListener();
		/* ------------------------------------------------------- */
		/* ================================================== */
	}


	public static DrugBrowser getInstance() {
		/* ================================================== */
		drugBrowser.setSize(900, 650);
		return drugBrowser;
		/* ================================================== */
	}
	
	
	
	/**
	 * @return
	 */
	public IDrug showDialog(Window parent, String searchText) {
		/* ================================================== */
		
		this.showingDialog =  WindowToolbox.reOwnDialog(drugBrowser, parent);
		showingDialog.pack();
		adjustTable();
		drugBrowser.setSize(900, 650);
		/* ------------------------------------------------------- */
		// use searchText
		/* ------------------------------------------------------- */
		this.nameTextField.setText(searchText);
		
		MainFrame.showDialogCentered(showingDialog);
		return selectedDrug;
		/* ================================================== */
	}
	
	
	/**
	 * @param searchText
	 * @return
	 */
	public IDrug showDialog(String searchText) {
		/* ================================================== */
		this.showingDialog = drugBrowser;
		if (this.drugBrowserModel.getRowCount() <= 0)
			return null;
		
		
		adjustTable();

		// use searchText
		this.nameTextField.setText(searchText);
		/* ------------------------------------------------------- */
		MainFrame.showDialogCentered(drugBrowser);

		return selectedDrug;
		/* ================================================== */
	}


	private void adjustTable() {
		/* ================================================== */
//		table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		table.getColumnModel().getColumn(getRowForName(HEADER_NAME)).setPreferredWidth(w250);
		table.getColumnModel().getColumn(getRowForName(HEADER_FORM)).setPreferredWidth(w80);
		table.getColumnModel().getColumn(getRowForName(HEADER_DOSE)).setPreferredWidth(w80);
		table.getColumnModel().getColumn(getRowForName(HEADER_PACKAGE)).setPreferredWidth(w300);
		table.getColumnModel().getColumn(getRowForName(HEADER_SUBSTANCE)).setPreferredWidth(w250);
//		table.getColumnModel().getColumn(getRowForName(HEADER_ATC)).setPreferredWidth(w150);
		table.getColumnModel().getColumn(getRowForName(HEADER_PRICE)).setPreferredWidth(w80);
		table.getColumnModel().getColumn(getRowForName(HEADER_MANUFACTURER)).setPreferredWidth(W200);
		
		/* ================================================== */
	}


	/**
	 * Init the componentes
	 */
	private void initComponent() {
		/* ====================================================== */
		this.cc = new CellConstraints();
		this.getContentPane().setBackground(Color.WHITE);
		// table
		initTablePanel();
		this.add(tablePanel);//, BorderLayout.CENTER);
		/* ====================================================== */
	}


	/**
	 * Inits the panel containing the table and the search fields
	 */
	private void initTablePanel() {
		/* ====================================================== */
		// create a model
		this.drugBrowserModel = new DrugBrowserModel(NewDrugWorker.getOptions());
		this.drugBrowserRenderer = new DrugBrowserRenderer();
		/* ------------------------------------------------------- */
		
		this.table = new JTable() {

			private static final long serialVersionUID = 1L;

			/* (non-Javadoc)
			 * @see javax.swing.JTable#updateUI()
			 */
			@Override
			public void updateUI() {
				/* ====================================================== */
				drugBrowserRenderer.clearHash();
				super.updateUI();
				/* ====================================================== */
			}
			
		};
		/* ------------------------------------------------------- */
		/* ------------------------------------------------------- */
		table.setModel(drugBrowserModel);
		table.setDefaultRenderer(Object.class, this.drugBrowserRenderer);
		
		table.setGridColor(Color.DARK_GRAY);
		table.setShowHorizontalLines(false);
		
		/* ------------------------------------------------------- */
		table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		/* ------------------------------------------------------- */
		this.tablePanel = new JPanel(new BorderLayout());
		tablePanel.setOpaque(false);
		
		JScrollPane scroll = new JScrollPane(table);
		tablePanel.add(scroll, BorderLayout.CENTER);

		/* ------------------------------------------------------- */
		// search panel
		this.searchPanel = new JPanel(new FormLayout(
				// cols
				"3dlu," +		// 1
				"fill:pref," +	// 2
				"3dlu," +		// 3
				"fill:pref," +	// 4
				"3dlu," +		// 5
				"fill:60dlu," +	// 6
				"8dlu," +		// 7
				"fill:pref," +	// 8
				"3dlu,"	+		// 9
				"fill:60dlu," +	// 10
				"fill:120dlu",
				// rows
				"3dlu," +
				"center:15dlu," +
				"3dlu"));
		searchPanel.setOpaque(false);
		/* ------------------------------------------------------- */
		//searchPanel.setName("panelDrugBrowserSearchPanel");
		//searchPanel.setBorder(BorderFactory.createTitledBorder(Translatrix.getTranslationString("prescription.core.search")));
		/* ------------------------------------------------------- */
		this.nameTextField 		= new JTextField();
		this.substanceTextField = new JTextField();
		this.atcTextField 		= new JTextField();
		/* ------------------------------------------------------- */
		nameTextField		.setName("textfieldDrugBrowserNameTextField");
		substanceTextField	.setName("textfieldDrugBrowserSubstanceTextField");
		atcTextField		.setName("textfieldDrugBrowserAtcTextField");
		/* ------------------------------------------------------- */
		nameTextField.getDocument().addDocumentListener(this);
		substanceTextField.getDocument().addDocumentListener(this);
		atcTextField.getDocument().addDocumentListener(this);
		/* ------------------------------------------------------- */
		searchPanel.add(new JLabel(Translatrix.getTranslationString("prescription.core.name")+":"), cc.xy(4, 2));
		searchPanel.add(nameTextField, cc.xy(6, 2));
		
		searchPanel.add(new JLabel(Translatrix.getTranslationString("prescription.name.drugbrowser.substance")+":"), cc.xy(8, 2));
		searchPanel.add(substanceTextField, cc.xy(10, 2));
		/* ------------------------------------------------------- */
		// clear button
		this.clearButton = ButtonFactory.createNarrowButton(GECAMedModule.getSmallIcon(GECAMedModule.EDIT_CLEAR_LTR));
		
		//clearButton = ButtonFactory.createNarrowButton(GECAMedModule.getSmallIcon(GECAMedModule.ADD));
		clearButton.setToolTipText(Translatrix.getTranslationString("list.clearTip"));
		searchPanel.add(new NamedComponent("", clearButton), cc.xy(2, 2));
		/* ------------------------------------------------------- */

		tablePanel.add(searchPanel, BorderLayout.NORTH);

		/* ====================================================== */
	}



	/**
	 * Init the listeners of the table (mouse, key)
	 */
	private void initTableListener()  {
		/* ================================================== */
		this.table.addMouseListener(this);
		this.table.addKeyListener(this);
		/* ================================================== */
	}


	private void initButtonActions() {
		/* ================================================== */
		this.okAction = new GECAMedAction(null,
				"prescription.core.ok",
				GECAMedModule.getSmallIcon(
						GECAMedIconNames.OK),
				null, // ?
				false, false, false) {

					/**
					 *
					 */
					private static final long serialVersionUID = 1L;

					/* (non-Javadoc)
					 * @see lu.tudor.santec.gecamed.core.gui.GECAMedAction#actionPerformed(java.awt.event.ActionEvent)
					 */
					@Override
					public void actionPerformed(ActionEvent p_Event) {
						
						int row = table.getSelectedRow();
						
						if (row == -1) DrugBrowser.this.selectedDrug = null;
						
						if (row >= 0) {
							DrugBrowser.this.selectedDrug =
								DrugBrowser.this.drugBrowserModel.getDrugByRow(
										DrugBrowser.this.drugBrowserModel.filteredToModel(row));
							try {
							    GECAMedLog.user(PatientManagerModule.MODULE_NAME,
								    CEFIP_PRESCRIBED, "DRUG: " + DrugBrowser.this.selectedDrug.getManufacturer().getName() + " " + DrugBrowser.this.selectedDrug.getName(), null);
							} catch (Exception e) {}
						}
						DrugBrowser.this.showingDialog.setVisible(false);
//						drugBrowserModel.triggerUpdate();
					}
		};
		

		this.cancelAction = new GECAMedAction(null,
				"prescription.core.cancel",
				GECAMedModule.getSmallIcon(
						GECAMedIconNames.CANCEL),
				null, // ?
				false, false, false) {

					/**
					 *
					 */
					private static final long serialVersionUID = 1L;

					/* (non-Javadoc)
					 * @see lu.tudor.santec.gecamed.core.gui.GECAMedAction#actionPerformed(java.awt.event.ActionEvent)
					 */
					@Override
					public void actionPerformed(ActionEvent p_Event) {
						/* ============================================= */
						DrugBrowser.this.selectedDrug = null;
						DrugBrowser.this.showingDialog.setVisible(false);
						/* ============================================= */
					}
		};
		/* ------------------------------------------------------ */

		okButton.setAction(okAction);
		cancelButton.setAction(cancelAction);

		/* ------------------------------------------------------- */
		this.clearAction = new GECAMedAction(null,
				"",
				GECAMedModule.getSmallIcon(
						GECAMedIconNames.EDIT_CLEAR_LTR),
				null, // ?
				false, false, false) {


			private static final long serialVersionUID = 1L;
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				/* ====================================================== */
				nameTextField.setText("");
				substanceTextField.setText("");
				atcTextField.setText("");
				/* ------------------------------------------------------- */
				updateNameFilter();
				/* ====================================================== */
			}

		};
		
		this.clearButton.setAction(clearAction);
		

		// =================================================================
		// define dialog wide key mappings
		// =================================================================
		KeyStroke strokeEsc = KeyStroke.getKeyStroke("ESCAPE");

		((JPanel) this.getContentPane()).getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
					.put(strokeEsc, "continue");
		((JPanel) this.getContentPane()).getActionMap().put("continue", cancelAction);


		KeyStroke strokeBackSpace = KeyStroke.getKeyStroke("BACK_SPACE");

		((JPanel) this.getContentPane()).getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
					.put(strokeBackSpace, "backspace");
		((JPanel) this.getContentPane()).getActionMap().put("backspace", clearAction);
		/* ================================================== */
	}


	class DrugBrowserRenderer extends DrugColorCellRenderer {

		/**
		 *
		 */
		private static final long serialVersionUID = 1L;
		private NumberFormat currencyFormatter;

		public DrugBrowserRenderer() {
			currencyFormatter = NumberFormat.getCurrencyInstance(Locale.GERMANY);
		}

		@Override
		public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
			/* ====================================================== */
			super.setHorizontalTextPosition(SwingConstants.LEFT);
			if (value instanceof List) {
				/* ------------------------------------------------------- */
				StringBuffer buff = new StringBuffer();
				try {
					int count = 0;
					for (Object o : (List<?>) value) {
						if (count > 0)
							buff.append(", ");
						buff.append(((AtcClass) o).getCode());
						count++;
					}
				}catch (Exception e) {
				}
				return super.getTableCellRendererComponent(table,
						buff.toString(), isSelected, hasFocus,
						row, column);
				/* ------------------------------------------------------- */
			}
			else if(column == getRowForName(HEADER_PRICE) && value instanceof Double) {
				/* ------------------------------------------------------- */
				JLabel l = (JLabel) super.getTableCellRendererComponent(table,
						currencyFormatter.format(value), isSelected, hasFocus,
						row, column);
				
				l.setHorizontalTextPosition(SwingConstants.RIGHT);
				return l;
				
//				return super.getTableCellRendererComponent(table,
//						""+value+"€", isSelected, hasFocus,
//						row, column);
				/* ------------------------------------------------------- */
			} else if (value instanceof IManufacturer) {
				/* ------------------------------------------------------- */
				return super.getTableCellRendererComponent(table,
						((IManufacturer) value).getName(), isSelected, hasFocus,
						row, column);
				/* ------------------------------------------------------- */
			}
			return super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
					row, column);
			/* ====================================================== */
		}


	}


	public void changedUpdate(DocumentEvent e) {
		/* ====================================================== */
		updateNameFilter();
		/* ====================================================== */
	}


	public void insertUpdate(DocumentEvent e) {
		/* ====================================================== */
		updateNameFilter();
		/* ====================================================== */
	}


	public void removeUpdate(DocumentEvent e) {
		/* ====================================================== */
		updateNameFilter();
		/* ====================================================== */
	}

	private void updateNameFilter() {
		/* ================================================== */
		if ("".equals(nameTextField.getText().trim()))
			drugBrowserModel.setFilteringEnabled(false, getRowForName(HEADER_NAME));
		else
			drugBrowserModel.setFilteringEnabled(true, getRowForName(HEADER_NAME));
		/* ------------------------------------------------------- */
		if ("".equals(substanceTextField.getText().trim()))
			drugBrowserModel.setFilteringEnabled(false, getRowForName(HEADER_SUBSTANCE));
		else
			drugBrowserModel.setFilteringEnabled(true, getRowForName(HEADER_SUBSTANCE));
		/* ------------------------------------------------------- */
//		if ("".equals(atcTextField.getText().trim()))
//			drugBrowserModel.setFilteringEnabled(false, getRowForName(HEADER_ATC));
//		else
//			drugBrowserModel.setFilteringEnabled(true, getRowForName(HEADER_ATC));
		/* ------------------------------------------------------- */
		// set filter text
		this.drugNameFilter.setFilter(nameTextField.getText());
		this.drugSubstanceFilter.setFilter(substanceTextField.getText());
		this.atcFilter.setFilter(atcTextField.getText());
		/* ------------------------------------------------------- */
		this.drugBrowserRenderer.clearHash();
		this.drugBrowserModel.update();
		this.drugBrowserModel.fireTableDataChanged();
		if(this.drugBrowserModel.getRowCount() != 0 ) this.table.setRowSelectionInterval(0, 0);
		/* ================================================== */
	}


	public void triggerUpdate() {
		/* ================================================== */
		drugBrowserModel.triggerUpdate();
		/* ================================================== */
	}


	public void mousePressed(MouseEvent arg0) {
		/* ====================================================== */
		if (!arg0.isPopupTrigger() && arg0.getClickCount() == 2) {
			/* ------------------------------------------------------- */
			// commit the selected drug and close the dialog
			this.okAction.actionPerformed(null);
			/* ------------------------------------------------------- */
		}
		/* ====================================================== */
	}

	public void mouseClicked(MouseEvent arg0) {}
	public void mouseEntered(MouseEvent arg0) {}
	public void mouseExited(MouseEvent arg0) {}
	public void mouseReleased(MouseEvent arg0) {}


	public void keyPressed(KeyEvent e) {
		/* ====================================================== */
		if (KeyEvent.VK_ENTER == e.getKeyCode())
			this.okAction.actionPerformed(null);
		/* ====================================================== */
	}


	public void keyReleased(KeyEvent e) {
		/* ====================================================== */
		// TODO Auto-generated method stub
		/* ====================================================== */
	}


	public void keyTyped(KeyEvent e) {
		/* ====================================================== */
		// TODO Auto-generated method stub
		/* ====================================================== */
	}






}
