/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/

package lu.tudor.santec.gecamed.prescription.gui.editor;

import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.Prescription;

/**
 * 
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: PrescriptionDataListener.java,v $
 * <br>Revision 1.1  2010-04-26 16:51:09  troth
 * <br>Redesign of the prescription view - all prescription class and new package
 * <br>
 */
public interface PrescriptionDataListener {

	/**
	 * set the prescription in mode modify to color the panel title and enable the save button
	 */
	void prescriptionModified();
	
	/**
	 * set the prescription in mode save to color the panel title and disable the save button
	 */
	void prescriptionSaved();
	
	/**
	 * set the prescription in the active panel and set all prescription data in the datafields
	 * @param p the prescription
	 */
	void setPrescription(Prescription p);
	
}
