/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.prescription.gui.editor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialog;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.Prescription;
import lu.tudor.santec.i18n.Translatrix;

/**
 * shows the PrescriptionDataPanel in the PrescriptionDataDialog.
 * the PrescriptionDataDialog open when the user clicks on the prescription button at the navigation bar on the right side of GECAMed
 * or on the resize button in the PrescriptionDataPanel on the consultation view.
 * 
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: PrescriptionDataDialog.java,v $
 * <br>Revision 1.11  2013-12-27 18:09:24  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.10  2010-10-05 13:42:43  troth
 * <br>Complete - # 560: Arztwechsel im Verschreibungs-Dialogfenster erm�glichen
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/560
 * <br>
 * <br>Revision 1.9  2010-09-07 12:46:23  troth
 * <br>Incomplete - # 629: Automatisches �berschreiben von Unfall-Nummer/Datum durch Dialog-verschreibung
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/629
 * <br>
 * <br>Revision 1.8  2010-09-06 14:29:22  troth
 * <br>Incomplete - # 625: Unfalldatum nicht angezeigt in Dialog-Verschreibungsfenster
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/625
 * <br>
 * <br>Revision 1.7  2010-09-02 12:28:14  troth
 * <br>Incomplete - # 621: Fehlerhafter Speicherverhalten beim Erstellen von Verschreibung in Dialogfenster
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/621
 * <br>
 * <br>Revision 1.6  2010-08-31 13:35:56  troth
 * <br>Incomplete - # 495: Mehrere Unstimmigkeiten mit Unfallnummer (auch #529)
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/495
 * <br>and Tickets 529, 613
 * <br>and new/redesign of AccidentPanel
 * <br>
 * <br>Revision 1.5  2010-07-28 12:34:51  troth
 * <br>code clean up
 * <br>
 * <br>Revision 1.4  2010-07-20 08:06:41  troth
 * <br>Part of # 563: Verwirrung bei der Gruppierung von einzelnen Verschreibungen
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/563
 * <br>
 * <br>Revision 1.3  2010-06-14 12:20:49  troth
 * <br>Bug Fix - when open  prescription dialog a incident have save without any entries
 * <br>
 * <br>Revision 1.2  2010-06-09 12:40:08  troth
 * <br>fix small bug - prescription field in panel are not longer cleared when prescription dialog is close oder cancel
 * <br>
 * <br>Revision 1.1  2010-04-26 16:51:09  troth
 * <br>Redesign of the prescription view - all prescription class and new package
 * <br>
 */
public class PrescriptionDataDialog extends GECAMedBaseDialog implements ActionListener {
	
	private static final long serialVersionUID = 1L;
	
	private PrescriptionDataPanel prescriptionDataPanel;

	private PrescriptionDataModel prescriptionDataModel; 

	
	/**
	 * @param prescriptionDataModel the data model use for the prescriptions
	 */
	public PrescriptionDataDialog(PrescriptionDataModel prescriptionDataModel) {
		super(Translatrix.getTranslationString("prescription.name"), true, true);
		this.prescriptionDataModel = prescriptionDataModel;
		this.prescriptionDataPanel = (PrescriptionDataPanel) this.prescriptionDataModel.getPrescriptionPanelView(false);  
		this.add(prescriptionDataPanel);
		this.setSize(920, 720);
		this.okButton.addActionListener(this);
		this.cancelButton.addActionListener(this);
	}
	
	
	/**
	 * shows the PrescriptionDataDialog and set the current prescription of the data model or a new prescription.
	 */
	public void showDialog() {
		
		if(this.prescriptionDataModel.isPrescriptionModified())
		{
			this.prescriptionDataModel.saveData();
		}
		this.prescriptionDataPanel.setWindowMode(true);
		if (this.prescriptionDataModel.getPrescription() == null)	
			this.prescriptionDataModel.setPrescription(new Prescription());
		else
			this.prescriptionDataModel.setPrescription(this.prescriptionDataModel.getPrescription());
		
		if (this.prescriptionDataPanel.getDateChooser().getDate() == null)
			this.prescriptionDataPanel.getDateChooser().setDate(new Date());
		 
		if (this.prescriptionDataModel.isPrescriptionModified()){
			this.prescriptionDataPanel.prescriptionModified();
		} else {
			this.prescriptionDataPanel.prescriptionSaved();
		}
		this.prescriptionDataPanel.initPhysicianCombobox();
		MainFrame.showDialogCentered(this);
		this.prescriptionDataPanel.setWindowMode(false);
		
	}
	
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if (e.getSource().equals(this.okButton))
			this.prescriptionDataModel.saveData();
	}

}
