/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 *
 */
package lu.tudor.santec.gecamed.prescription.gui.drug.lists.cefip;

import java.util.List;

import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.IDrug;
import lu.tudor.santec.gecamed.prescription.ejb.entity.dataclasses.DrugLight;
import lu.tudor.santec.gecamed.prescription.ejb.session.beans.drug.lists.cefip.CefipDrugManagerBean;
import lu.tudor.santec.gecamed.prescription.ejb.session.interfaces.drug.lists.cefip.CefipDrugManager;
import lu.tudor.santec.gecamed.prescription.gui.drug.IDrugListModule;

/**
 *
 * The IDrugList implementation  of the Cefip Druglist module.
 *
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: CefipDrugListModule.java,v $
 * <br>Revision 1.5  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-01-15 09:58:55  heinemann
 * <br>better documentation
 * <br>
 * <br>Revision 1.3  2007-11-20 08:58:55  hermen
 * <br>moved Managerfactory to core.utils and refactured code to use ManagerFactory instead of context.lookup
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:44  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.5  2007/02/21 10:00:40  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1.2.4  2007/02/08 16:45:12  heinemann
 * <br>many changes
 * <br>
 * <br>Revision 1.1.2.3  2007/01/19 10:36:34  heinemann
 * <br>cleaning
 * <br>
 * <br>Revision 1.1.2.2  2007/01/04 13:51:37  heinemann
 * <br>The great space cleaning lady has done a big bunch of refactoring
 * <br>
 * <br>Revision 1.1.2.1  2006/12/20 13:47:04  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2006/09/07 13:35:38  heinemann
 * <br>many changes
 * <br>
 */
public class CefipDrugListModule implements IDrugListModule {

	/**
	 * The name of the module
	 */
	private final String moduleName = "CefipDrugListModule";

	/**
	 *	The lists name like it is stored in the database
	 */
	private final String listName = "CEFIP List";

	private Integer listId;

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.prescription.gui.drug.IDrugListModule#getModuleName()
	 */
	public String getModuleName() {
		/* ============================================= */
		return moduleName;
		/* ============================================= */
	}


	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.prescription.gui.drug.IDrugListModule#getListId()
	 */
	public Integer getListId() {
		/* ====================================================== */
		if (this.listId == null)
			this.listId = getManager().getListId();
		/* ------------------------------------------------------ */
		return this.listId;
		/* ====================================================== */
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.prescription.gui.drug.IDrugListModule#getListName()
	 *
	 * The name, how it is in the drug_lists table of the database
	 */
	public String getListName() {
		/* ============================================= */
		return listName;
		/* ============================================= */
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.prescription.gui.drug.IDrugListModule#getDrugByName(java.lang.String)
	 */
	public IDrug getDrugByName(String name) {
		/* ============================================= */
		// TODO Auto-generated method stub
		return null;
		/* ============================================= */
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.prescription.gui.drug.IDrugListModule#getDrugById(java.lang.Integer)
	 */
//	public IDrug getDrugById(Integer id) {
//		/* ============================================= */
//		return getManager().getDrugById(id);
//		/* ============================================= */
//	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.prescription.gui.drug.IDrugListModule#getDrugsBySubstanceId(java.lang.Integer)
	 */
	public List<IDrug> getDrugsBySubstanceId(Integer id) {
		/* ============================================= */
		// TODO Auto-generated method stub
		return null;
		/* ============================================= */
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.prescription.gui.drug.IDrugListModule#getDrugs(java.lang.Integer, java.lang.Integer)
	 */
	@SuppressWarnings("unchecked")
	public List<IDrug> getDrugs(Integer start, Integer pageSize) {
		/* ============================================= */
		return getManager().getDrugs(start, pageSize);
		/* ============================================= */
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.prescription.gui.drug.IDrugListModule#getLightDrugs(java.lang.Integer, java.lang.Integer)
	 */
//	public List<DrugLight> getLightDrugs(Integer start, Integer pageSize) {
//		/* ============================================= */
//		return getManager().getLightDrugs(start, pageSize);
//		/* ============================================= */
//	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.prescription.gui.drug.IDrugListModule#getLightDrugsByNamePattern(java.lang.String, java.lang.Integer)
	 */
	public List<DrugLight> getLightDrugsByNamePattern(String pattern,
			Integer limit) {
		/* ============================================= */
		return getManager().getLightDrugsByNamePattern(pattern, limit);
		/* ============================================= */
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.prescription.gui.drug.IDrugListModule#getLightDrugsBySubstance(java.lang.Integer)
	 */
	public List<DrugLight> getLightDrugsBySubstance(Integer id) {
		/* ============================================= */
		// TODO Auto-generated method stub
		return null;
		/* ============================================= */
	}


	/* *********************************************************
	 *  Module methods
	 */


	/**
	 * Returns a reference to the CefipDrugManager Session Bean
	 * calls ManagerFactory.getRemote(CefipDrugManagerBean.class)
	 * @return
	 */
	public static CefipDrugManager getManager() {
		/* ====================================================== */
		return (CefipDrugManager) ManagerFactory.getRemote(CefipDrugManagerBean.class);
		/* ====================================================== */
	}


	public List<String> getOptions() {
		/* ====================================================== */

		return null;
		/* ====================================================== */
	}



}
