/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.prescription.gui.actionhandler;

import java.awt.event.ActionEvent;
import java.util.List;

import lu.tudor.santec.gecamed.core.gui.listener.AEntryAction;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.gecamed.patient.gui.incident.IncidentPanel;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.Prescription;
import lu.tudor.santec.gecamed.prescription.ejb.session.beans.PrescriptionManagerBean;
import lu.tudor.santec.gecamed.prescription.ejb.session.interfaces.PrescriptionManager;
import lu.tudor.santec.gecamed.prescription.gui.PrescriptionIcons;
import lu.tudor.santec.gecamed.prescription.gui.editor.PrescriptionDataModel;
//import lu.tudor.santec.gecamed.prescription.gui.neweditor.PrescriptionEditor;
import lu.tudor.santec.i18n.Translatrix;

/**
 * buttonaction copy text in the right-click-popup of PrescriptionHistoryView.
 * copies the text of a prescription to another prescription.
 * 
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: PrescriptionEntryCopyTextAction.java,v $
 * <br>Revision 1.1  2010-11-26 16:50:41  troth
 * <br>Complete - # 682: Mehrfache Wiederverschreibungen nicht mehr mglich in Release 1.1.01
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/682
 * <br>
 */
public class PrescriptionEntryCopyTextAction extends AEntryAction {

	private static final long serialVersionUID = 1L;

	private IncidentEntry entry2CopyText;
	
	private PrescriptionManager manager;
	
	private PrescriptionDataModel prescriptionDataModel;
	
	public PrescriptionEntryCopyTextAction() {
		super(Translatrix.getTranslationString("prescription.buttons.copyText"),
				PrescriptionIcons.getSmallIcon(PrescriptionIcons.COPY));
		this.manager = (PrescriptionManager) ManagerFactory.getRemote(PrescriptionManagerBean.class);
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.listener.AEntryAction#setEntry(lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry)
	 */
	public void setEntry(IncidentEntry entry) {
		this.entry2CopyText = entry;
	}

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		List<Prescription> prescription2CopyText = manager.getPrescriptionByIncidentEntry(entry2CopyText.getId());
		
		this.prescriptionDataModel = PatientManagerModule.getInstance().getPatientPanel().getPrescriptionDataModel();
		
		if (prescription2CopyText != null && prescription2CopyText.size() > 0)
		{	
			if (this.prescriptionDataModel.getPrescription().getTextContent() == null)
				this.prescriptionDataModel.getPrescription().setTextContent(prescription2CopyText.get(0).getTextContent());
			else
				this.prescriptionDataModel.getPrescription().setTextContent(this.prescriptionDataModel.getPrescription().getTextContent() + "\n"+ prescription2CopyText.get(0).getTextContent());
			
			PatientManagerModule.getInstance().getPatientPanel().showPanel(IncidentPanel.name);
			
			this.prescriptionDataModel.updatePrescriptionPannels();
			this.prescriptionDataModel.prescriptionChanged(true);
		}
	}
}