/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * 
 */
package lu.tudor.santec.gecamed.prescription.ejb.session.interfaces;

import java.util.List;

import javax.annotation.security.RolesAllowed;
import javax.ejb.Remote;

import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.PosologyTemplate;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.Prescription;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.PrescriptionTemplate;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.PrescriptionType;

/**
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: PrescriptionManager.java,v $
 * <br>Revision 1.16  2010-11-04 13:34:30  troth
 * <br>update of the function that "create Incident Entries for Prescription how have one together" now in the second step the Select select only the needed Prescriptions thats much more faster.
 * <br>
 * <br>Revision 1.15  2010-11-03 17:45:06  troth
 * <br>expansion of the function that "create Incident Entries for Prescription how have one together" now it also
 * <br>1. sync the incidentIds of Prescriptions and there Incident Entry
 * <br>2. deletes Incidents how have no Incident Entries and no back link from a Prescription
 * <br>
 * <br>Revision 1.14  2010-07-22 09:49:39  troth
 * <br>add implementation - # 239: Prescription Templates linked to physician
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/239
 * <br>
 * <br>Revision 1.13  2009-05-06 16:00:05  heinemann
 * <br>added method to generate printable output of the incident entrys
 * <br>
 * <br>Revision 1.12  2008-12-17 15:23:06  heinemann
 * <br>initial commit after merging of branch new prescription
 * <br>
 * <br>Revision 1.11.2.2  2008-12-15 17:16:05  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.11.2.1  2008-12-15 14:08:21  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.11  2008-11-12 17:16:33  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.10  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.9  2008-03-20 16:08:14  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.8  2008-03-10 12:37:53  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.7  2008-03-06 15:34:42  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.6  2008-01-15 07:43:04  heinemann
 * <br>son doku
 * <br>
 * <br>Revision 1.5  2007/03/02 08:28:38  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.4.2.7  2007/01/15 08:59:14  hermen
 * <br># 9: Improve the posology chooser
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/9
 * <br>
 * <br>added posologytemplates bean
 * <br>
 * <br>Revision 1.4.2.6  2007/01/04 13:51:37  heinemann
 * <br>The great space cleaning lady has done a big bunch of refactoring
 * <br>
 * <br>Revision 1.4.2.5  2006/12/28 10:32:01  heinemann
 * <br>bug fixing and template improvements
 * <br>
 * <br>Revision 1.4.2.4  2006/12/22 13:17:40  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4.2.3  2006/12/21 14:26:07  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4.2.2  2006/12/19 14:51:50  heinemann
 * <br>printing etc
 * <br>
 * <br>Revision 1.4.2.1  2006/12/14 09:34:01  heinemann
 * <br>many changes
 * <br>
 */

@Remote
public interface PrescriptionManager {
	
	
	
	public static final String ENTRY_TYPE = "prescription";
	
	
	
	/**
	 * Get all user templates for the given type
	 * 
	 * @param type
	 * @return
	 */
	@RolesAllowed("gecam")
	public List<PrescriptionTemplate> getTemplates(String type, Integer physicianId);

	/**
	 * Get all PrecriptionTypes
	 * 
	 * @return
	 */
	@RolesAllowed("gecam")
	public List<PrescriptionType> getPrescriptionTypes();

	/**
	 * Save the prescriptions.
	 * They must have an incident id set!!!
	 * 
	 * @param modifiedPrescriptions
	 * @return
	 */
	@RolesAllowed("gecam")
	public List<Prescription> savePrescription(List<Prescription> modifiedPrescriptions);
	
	/**
	 * Save one prescription!
	 * 
	 * @param prescriptions
	 * @return
	 */
	@RolesAllowed("gecam")
	public Prescription savePrescription(Prescription prescriptions);
	
	
	/**
	 * Save the given Prescription template.<br/>
	 * Ensure, that the bidirectional mapping with the TemplateDrug is filled!
	 * 
	 * @param template
	 */
	@RolesAllowed("gecam")
	public PrescriptionTemplate saveTemplate(PrescriptionTemplate template);
	
	
	/**
	 * Get all antecedent prescriptions of the patient by the type id
	 * 
	 * @param patientId
	 * @param typeId
	 * @return
	 */
	@RolesAllowed("gecam")
	public List<Prescription> getAntecedentPrescriptions(Integer patientId, Integer typeId);
	
	
	
	/**
	 * Get all prescriptions that are linked to the incident
	 * 
	 * @param id
	 * @return
	 */
	@RolesAllowed("gecam")
	public List<Prescription> getPrescriptionByIncidentId(Integer id);
	
	/**
	 * @param prescId
	 * @return
	 */
	@RolesAllowed("gecam")
	public Prescription getPrescription(Integer prescId);
	
	/**
	 * @param entryId
	 * @return
	 */
	@RolesAllowed("gecam")
	public List<Prescription> getPrescriptionByIncidentEntry(Integer entryId);
	
	/**
	 * 
	 * Delete the templates
	 * 
	 * @param templates
	 */
	@RolesAllowed("gecam")
	public void deleteTemplates(List<PrescriptionTemplate> templates);
	
	
	/**
	 * Save the given Posology template.<br/>
	 * 
	 * @param template
	 */
	@RolesAllowed("gecam")
	public PosologyTemplate savePosologyTemplate(PosologyTemplate template);
	
	/**
	 * 
	 * Delete the marked Posology template
	 * 
	 * @param template
	 */
	@RolesAllowed("gecam")
	public void deletePosologyTemplate(PosologyTemplate template);
	
	
	/**
	 * Get all user Posology templates for the given physicianID
	 * 
	 * @param physicianID
	 * @return
	 */
	@RolesAllowed("gecam")
	public List<PosologyTemplate> getPosologyTemplates(Integer physicianID);
	
	/**
	 * Returns all prescriptions of a patient
	 * 
	 * @param patientId
	 * @return
	 */
	@RolesAllowed("gecam")
	public List<Prescription> getPrescriptions(Integer patientId);
	
	/**
	 * @return
	 */
//	@RolesAllowed("gecam")
//	public boolean convertPrescriptionRevisions();
	@RolesAllowed("gecam")
	public boolean convertPrescriptionRevision(Integer revId);
	
	/**
	 * @return
	 */
	@RolesAllowed("gecam")
	public List<Integer> getPrescriptionRevisionIdsToConvert();
	
	
	/**
	 * Returns all prescription templates of type medicin
	 * 
	 * @return
	 */
	public List<PrescriptionTemplate> getAllTemplates4Convertion();

	public void convert_1_0_9_PrescriptionTemplate(PrescriptionTemplate t);
	
	/**
	 * Returns all prescriptions of type medicine to convert
	 * 
	 * @param start
	 * @param pageSize
	 * @return
	 */
	public List<Prescription> getAllPrescription4Convert(Integer start, Integer pageSize);
	
	/**
	 * Returns all prescriptions witch have no the same incident id like there incident entry 
	 * 
	 * @return List of prescriptions
	 */
	public List<Integer> getPrescriptionsNoSyncWithIncidentEntry();
}
