/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * 
 */
package lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.cefip;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * 
 * Entity class to import the manufacturer data coming from the CEFIP list.
 * Use it just for importing data. To read use the ManufacturerData class.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: CefipManufacturerData.java,v $
 * <br>Revision 1.2  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-01-14 14:19:01  heinemann
 * <br>son docu
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:38  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.1  2006/12/20 13:46:38  heinemann
 * <br>*** empty log message ***
 * <br>
 */
@Entity
@Table(name="cefip_manufacturer", schema="prescription")
public class CefipManufacturerData extends GECAMedEntityBean {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	
	private String num;
	
	private String nom;
	
	private String ad1;
	
	private String ad2;
	
	private String spec;
	
	private String du;
	
	private String au;
	
	
	public CefipManufacturerData() {
		/* ====================================================== */
		super();
		/* ====================================================== */
	}


	/**
	 * @return the ad1
	 */
	@Column(name="ad1")
	public String getAd1() {
		return ad1;
	}


	/**
	 * @return the ad2
	 */
	@Column(name="ad2")
	public String getAd2() {
		return ad2;
	}


	/**
	 * @return the au
	 */
	@Column(name="au")
	public String getAu() {
		return au;
	}


	/**
	 * @return the du
	 */
	@Column(name="du")
	public String getDu() {
		return du;
	}


	/**
	 * @return the nom
	 */
	@Column(name="nom")
	public String getNom() {
		return nom;
	}


	/**
	 * @return the num
	 */
	@Column(name="num")
	public String getNum() {
		return num;
	}


	/**
	 * @return the spec
	 */
	@Column(name="spec")
	public String getSpec() {
		return spec;
	}


	/**
	 * @param ad1 the ad1 to set
	 */
	public void setAd1(String ad1) {
		this.ad1 = ad1;
	}


	/**
	 * @param ad2 the ad2 to set
	 */
	public void setAd2(String ad2) {
		this.ad2 = ad2;
	}


	/**
	 * @param au the au to set
	 */
	public void setAu(String au) {
		this.au = au;
	}


	/**
	 * @param du the du to set
	 */
	public void setDu(String du) {
		this.du = du;
	}


	/**
	 * @param nom the nom to set
	 */
	public void setNom(String nom) {
		this.nom = nom;
	}


	/**
	 * @param num the num to set
	 */
	public void setNum(String num) {
		this.num = num;
	}


	/**
	 * @param spec the spec to set
	 */
	public void setSpec(String spec) {
		this.spec = spec;
	}
	
	/* ************************************************************ */
	
	/* ************************************************************ */
	
	
}
