/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.cefip;

import java.util.List;

import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.AtcClass;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.IDrug;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug.IManufacturer;

/**
 * 
 * Implementation of the IDrug interface for the CEFIP list.
 * It is filled in the CefipDrugManagerBean.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 13.02.2007
 * 11:48:49
 *
 *
 * @version
 * <br>$Log: CefipDrug.java,v $
 * <br>Revision 1.6  2013-02-22 08:46:50  kutscheid
 * <br>remove the tupel classes (please redeploy)
 * <br>
 * <br>Revision 1.5  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-01-14 14:19:01  heinemann
 * <br>son docu
 * <br>
 * <br>Revision 1.3  2007/03/02 08:28:39  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.2.2.3  2007/02/21 09:59:47  heinemann
 * <br>*** empty log message ***
 * <br>
 *
 */
public class CefipDrug implements IDrug {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;


	private Integer id;
	private Integer drugListId;
	private String name;
	private String applicationForm;
	private String dose;
	private String packages;
	private Double price;
	private String substances;
	private Integer manufacturerId;
	private IManufacturer manufacturer;
	private List<AtcClass> atcClasses;

	private List<String[]> options;
	
	
	
	public CefipDrug() {
		
	}
	
	/**
	 * @return the applicationForm
	 */
	public String getApplicationForm() {
		return applicationForm;
	}
	/**
	 * @param applicationForm the applicationForm to set
	 */
	public void setApplicationForm(String applicationForm) {
		this.applicationForm = applicationForm;
	}
	/**
	 * @return the atcClasses
	 */
	public List<AtcClass> getAtcClasses() {
		return atcClasses;
	}
	/**
	 * @param atcClasses the atcClasses to set
	 */
	public void setAtcClasses(List<AtcClass> atcClasses) {
		this.atcClasses = atcClasses;
	}
	/**
	 * @return the dose
	 */
	public String getDose() {
		return dose;
	}
	/**
	 * @param dose the dose to set
	 */
	public void setDose(String dose) {
		this.dose = dose;
	}
	/**
	 * @return the drugListId
	 */
	public Integer getDrugListId() {
		return drugListId;
	}
	/**
	 * @param drugListId the drugListId to set
	 */
	public void setDrugListId(Integer drugListId) {
		this.drugListId = drugListId;
	}
	/**
	 * @return the id
	 */
	public Integer getId() {
		return id;
	}
	/**
	 * @param id the id to set
	 */
	public void setId(Integer id) {
		this.id = id;
	}
	/**
	 * @return the manufacturer
	 */
	public IManufacturer getManufacturer() {
		return manufacturer;
	}
	/**
	 * @param manufacturer the manufacturer to set
	 */
	public void setManufacturer(IManufacturer manufacturer) {
		this.manufacturer = manufacturer;
	}
	/**
	 * @return the manufacturerId
	 */
	public Integer getManufacturerId() {
		return manufacturerId;
	}
	/**
	 * @param manufacturerId the manufacturerId to set
	 */
	public void setManufacturerId(Integer manufacturerId) {
		this.manufacturerId = manufacturerId;
	}
	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return the packages
	 */
	public String getPackage() {
		return packages;
	}
	/**
	 * @param packages the packages to set
	 */
	public void setPackage(String packages) {
		this.packages = packages;
	}
	/**
	 * @return the price
	 */
	public Double getPrice() {
		return price;
	}
	/**
	 * @param price the price to set
	 */
	public void setPrice(Double price) {
		this.price = price;
	}
	/**
	 * @return the substances
	 */
	public String getSubstances() {
		return substances;
	}
	/**
	 * @param substances the substances to set
	 */
	public void setSubstances(String substances) {
		this.substances = substances;
	}
	/**
	 * @return the options
	 */
	public List<String[]> getOptions() {
		return options;
	}
	/**
	 * @param options the options to set
	 */
	public void setOptions(List<String[]> options) {
		this.options = options;
	}


}
