/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 *
 */
package lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug;

import java.io.Serializable;

/**
 * Basic interface for manufacturers. Each drug list might have its own list of manufactueres.
 * To gain a simple and standard interface, the IManufacturer interface has the basic information that
 * are important for that. You are free to have more information in your implementation.
 *
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: IManufacturer.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-14 14:19:01  heinemann
 * <br>son docu
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:38  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.2  2007/02/21 09:59:47  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1.2.1  2006/12/20 13:46:23  heinemann
 * <br>*** empty log message ***
 * <br>
 */
public interface IManufacturer extends Serializable{


	/**
	 * Return the id of the manufacturer
	 * 
	 * @return
	 */
	public Integer getId();
	/**
	 * @param id
	 */
	public void setId(Integer id);

	/**
	 * The name of the manufacturer
	 * 
	 * @return
	 */
	public String getName();
	/**
	 * @param name
	 */
	public void setName(String name);

	/**
	 * The street of the manufacturer
	 * 
	 * @return
	 */
	public String getStreet();
	/**
	 * @param street
	 */
	public void setStreet(String street);

	/**
	 * @return
	 */
	public String getCity();
	/**
	 * @param city
	 */
	public void setCity(String city);

}
