/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 *
 */
package lu.tudor.santec.gecamed.prescription.ejb.entity.beans.drug;

import java.io.Serializable;
import java.util.List;

/**
 * Basic interface for all drugs that should be used in the system.
 * It offers some basic functionallity to gain a standard interface
 * for the modules.<br/>
 * As drugs from different list repositories, e.G. CEFIP, Rote Liste, Vidal, etc possibly have more 
 * properties we must have a good fundamental property set that are available in all lists.
 * Any further propteries can be put in the option tupel list.
 *
 *
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: IDrug.java,v $
 * <br>Revision 1.5  2013-02-22 08:46:50  kutscheid
 * <br>remove the tupel classes (please redeploy)
 * <br>
 * <br>Revision 1.4  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-14 14:19:01  heinemann
 * <br>son docu
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:38  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.2  2007/02/21 09:59:47  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1.2.1  2006/12/20 13:46:23  heinemann
 * <br>*** empty log message ***
 * <br>
 */
public interface IDrug extends Serializable {


	// the id
	public Integer getId();
	public void setId(Integer id);

	// the drug list id
	public Integer getDrugListId();
	public void setDrugListId(Integer drugListId);

	// the name of the drug
	public String getName();
	public void setName(String name);

	// the manufacturer
	public IManufacturer getManufacturer();
	public void setManufacturer(IManufacturer manufacturerId);

	// the manufacturer id
	public Integer getManufacturerId();
	public void setManufacturerId(Integer manufacturerId);

	// The atc classes
	public List<AtcClass> getAtcClasses();
	public void setAtcClasses(List<AtcClass> atcClasses);

	// the application form
	public String getApplicationForm();
	public void setApplicationForm(String applicationForm);

	// the price in EURO
	public Double getPrice();
	public void setPrice(Double price);

	/**
	 * The dose
	 * @return
	 */
	public String getDose();
	public void setDose(String dose);

	public String getSubstances();
	public void setSubstances(String Substances);

	public String getPackage();
	public void setPackage(String pck);


	public List<String[]> getOptions();
	public void setOptions(List<String[]> options);


}
