/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * 
 */
package lu.tudor.santec.gecamed.prescription.ejb.entity.beans;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Represents a print of a prescription. Stores the printing date, the user who triggerd the print
 * etc.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: PrintPrescription.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-14 15:58:22  heinemann
 * <br>son doku
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:39  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.1  2007/01/04 13:51:37  heinemann
 * <br>The great space cleaning lady has done a big bunch of refactoring
 * <br>
 * <br>Revision 1.1.2.2  2006/12/19 14:51:33  heinemann
 * <br>printing etc
 * <br>
 * <br>Revision 1.1.2.1  2006/12/14 09:34:00  heinemann
 * <br>many changes
 * <br>
 */

@Entity
@Table(name="print_prescription", schema="prescription")
public class PrintPrescription extends GECAMedEntityBean {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	
	private Integer prescriptionId;
	private Integer printedById;
	private Date printDate;
	private Prescription prescription;
	
	
	private Boolean isCopy;
	
	
	/**
	 * 
	 */
	public PrintPrescription() {
		/* ====================================================== */

		/* ====================================================== */
	}


	/**
	 * @return the prescriptionId
	 */
	@Column(name="prescription_id", insertable=false, updatable=false)
	public Integer getPrescriptionId() {
		return prescriptionId;
	}


	/**
	 * @return the printDate
	 */
	@Column(name="print_date")
	public Date getPrintDate() {
		return printDate;
	}


	/**
	 * @return the printedById
	 */
	@Column(name="printed_by_id")
	public Integer getPrintedById() {
		return printedById;
	}


	/**
	 * @param prescriptionId the prescriptionId to set
	 */
	public void setPrescriptionId(Integer prescriptionId) {
		this.prescriptionId = prescriptionId;
	}


	/**
	 * @param printDate the printDate to set
	 */
	public void setPrintDate(Date printDate) {
		this.printDate = printDate;
	}


	/**
	 * @param printedById the printedById to set
	 */
	public void setPrintedById(Integer printedById) {
		this.printedById = printedById;
	}


	/**
	 * @return the isCopy
	 */
	@Column(name="is_copy")
	public Boolean getIsCopy() {
		return isCopy;
	}


	/**
	 * @param isCopy the isCopy to set
	 */
	public void setIsCopy(Boolean isCopy) {
		this.isCopy = isCopy;
	}


	/**
	 * @return the prescription
	 */
	@ManyToOne
	@JoinColumn(name="prescription_id")
	public Prescription getPrescription() {
		return prescription;
	}


	/**
	 * @param prescription the prescription to set
	 */
	public void setPrescription(Prescription prescription) {
		this.prescription = prescription;
	}
	
	
	
	
	
	
	

}
