/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.prescription.ejb.entity.beans;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;


/**
 * @author martin.heinemann@tudor.lu
 * 14.01.2008
 * 15:52:09
 *
 *
 * @version
 * <br>$Log: PrescriptionType.java,v $
 * <br>Revision 1.11  2008-10-22 14:20:26  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.10  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.9  2008-01-14 15:58:22  heinemann
 * <br>son doku
 * <br>
 *   
 */
@NamedQueries ({
	@NamedQuery(name = PrescriptionType.GET_ALL_TYPES,
			query = "SELECT Object(o) FROM PrescriptionType o")
})


@Entity
@Table(name = "prescription_types", schema = "prescription")
public class PrescriptionType extends GECAMedEntityBean implements java.io.Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	public static final String GET_ALL_TYPES = "findAllPrescriptionTypes";
	
	
	/* ------------------------------------------------------ */
	// constants for the types  in the database
	public static final String MEDICINE = "medicin";
	public static final String RADIOGRAPHY = "radiography";
	public static final String CERIFICATS = "certificats";
	public static final String PHYSIOTHERAPY = "physiotherapy";
	public static final String NURSING = "nursing";
	public static final String TRANSFERALS = "transferals";
	public static final String BIOLOGY = "biology";
	
	
	// Fields    

	private String name;

	// Constructors

	/** default constructor */
	public PrescriptionType() {
	}

	// Property accessors
	@Column(name = "name", unique = false, nullable = false, insertable = true, updatable = true, length = 100)
	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}
}
