/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.prescription.ejb.entity.beans;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;




@javax.persistence.NamedQueries
({
@NamedQuery(name = PrescriptionRevision.FIND_PRESC_REVISION,
		query = "SELECT OBJECT(o) FROM PrescriptionRevision o " +
					"WHERE o.prescriptionId = :prescriptionId " +
					"AND o.revisionId = (SELECT MAX(t.revisionId) FROM PrescriptionRevision t " +
											"WHERE t.prescriptionId = o.prescriptionId)")
})



/**
 * Mapped on the prescription revision table.
 * Used to keep track of changes on prescriptions.
 * 
 * The table gets a new entry each time a prescription is created or modified.
 * 
 * @author martin.heinemann@tudor.lu
 * 12.03.2007
 * 10:11:21
 *
 *
 * @version
 * <br>$Log: PrescriptionRevision.java,v $
 * <br>Revision 1.8  2013-01-07 11:25:52  ferring
 * <br>Unneeded limitations in Prescription and PrescriptionRevision removed and changed VARCHAR(100) of physician speciality to TEXT in DB
 * <br>
 * <br>Revision 1.7  2008-12-17 15:23:06  heinemann
 * <br>initial commit after merging of branch new prescription
 * <br>
 * <br>Revision 1.6.2.1  2008-12-15 14:08:21  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.6  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-07-23 15:13:57  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2008-07-23 10:00:50  heinemann
 * <br>removed stand_alone column from prescription and prescription_revisions table
 * <br>
 * <br>Revision 1.3  2008-03-10 12:37:52  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2008-01-14 15:58:22  heinemann
 * <br>son doku
 * <br>
 * <br>Revision 1.1  2007/03/12 14:32:10  heinemann
 * <br>Complete - # 46: make printed prescriptions editable
 * <br>http://santec.tudor.lu:8888/gecamed/ticket/46
 * <br>
 *
 */
@Entity
@Table(name = "prescription_revisions", schema = "prescription")
public class PrescriptionRevision extends GECAMedEntityBean implements java.io.Serializable {

	// Fields



	public static final String FIND_PRESC_REVISION = "findAllPrescriptionRevisionForPrescriptionId";

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private Integer prescriptionId;
	private Integer revisionId;

	private Integer prescriptionTypeId;
	private Integer incidentId;
	private Date creationDate;
	private Integer createdBy;
	private Integer physicianId;
	private Date prescriptionDate;
	private Date expiryDate;

	private String accidentNr;
	private Date accidentDate;

	private String patientName;
	private String patientFirstName;
	private String patientMaidenName;
	private String patientAddress;
	private String patientSocialSecurityNumber;
	private String physicianFullName;
	private String physicianUcmCode;
	private String physicianSpeciality;
	private String physicianAddress;
	private String physicianPhone;
	private String physicianFax;
	private String physicianGsm;
	private String textContent;
	private Boolean isChronic;
	private List<PrescriptionDrugRevision> prescriptionDrugs
					= new ArrayList<PrescriptionDrugRevision>(0);
	private Set<PrintPrescription> printPrescriptions = new HashSet<PrintPrescription>(0);

	private Integer incidentEntryId;
	private IncidentEntry incidentEntry;

	// Constructors

	/** default constructor */
	public PrescriptionRevision() {
	}


	/**
	 * @param p
	 */
	public PrescriptionRevision(Prescription p) {
		/* ================================================== */
		copyPrescriptionData(p);
		/* ================================================== */
	}


	// Property accessors

	/**
	 * Get the id of the original prescription
	 * @return
	 */
	@Column(name="prescription_id")
	public Integer getPrescriptionId() {
		/* ================================================== */
		return this.prescriptionId;
		/* ================================================== */
	}
	/**
	 * Set the id of the original prescription
	 * @param prescriptionId
	 */
	public void setPrescriptionId(Integer prescriptionId) {
		/* ================================================== */
		this.prescriptionId = prescriptionId;
		/* ================================================== */
	}


	/**
	 * @return
	 */
	@Column(name="revision_id")
	public Integer getRevisionId() {
		/* ================================================== */
		return this.revisionId;
		/* ================================================== */
	}
	public void setRevisionId(Integer revisionId) {
		/* ================================================== */
		this.revisionId = revisionId;
		/* ================================================== */
	}

	@Column(name = "prescription_types_id")
	public Integer getPrescriptionTypeId() {
		return this.prescriptionTypeId;
	}

	public void setPrescriptionTypeId(Integer prescriptionTypeId) {
		this.prescriptionTypeId = prescriptionTypeId;
	}

	@Column(name = "incident_id")
	public Integer getIncidentId() {
		return this.incidentId;
	}

	public void setIncidentId(Integer incidentId) {
		this.incidentId = incidentId;
	}
	
	
	
	/**
	 * @return the incidentEntry
	 */
	@ManyToOne
	@JoinColumn(name="incident_entry_id")
	public IncidentEntry getIncidentEntry() {
		return incidentEntry;
	}


	/**
	 * @param incidentEntry the incidentEntry to set
	 */
	public void setIncidentEntry(IncidentEntry incidentEntry) {
		this.incidentEntry = incidentEntry;
	}


	/**
	 * @return the incidentEntryId
	 */
	@Column(name="incident_entry_id", insertable=false, updatable=false)
	public Integer getIncidentEntryId() {
		return incidentEntryId;
	}


	/**
	 * @param incidentEntryId the incidentEntryId to set
	 */
	public void setIncidentEntryId(Integer incidentEntryId) {
		this.incidentEntryId = incidentEntryId;
	}

	
	
	
	
	
	@Column(name = "creation_date")
	public Date getCreationDate() {
		return this.creationDate;
	}

	public void setCreationDate(Date creationDate) {
		this.creationDate = creationDate;
	}

	@Column(name = "created_by")
	public Integer getCreatedBy() {
		return this.createdBy;
	}

	public void setCreatedBy(Integer createdBy) {
		this.createdBy = createdBy;
	}

	@Column(name = "physician_id")
	public Integer getPhysicianId() {
		return this.physicianId;
	}

	public void setPhysicianId(Integer physicianId) {
		this.physicianId = physicianId;
	}
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "prescription_date")
	public Date getPrescriptionDate() {
		return this.prescriptionDate;
	}

	public void setPrescriptionDate(Date prescriptionDate) {
		this.prescriptionDate = prescriptionDate;
	}
	@Temporal(TemporalType.DATE)
	@Column(name = "expiry_date")
	public Date getExpiryDate() {
		return this.expiryDate;
	}

	public void setExpiryDate(Date expiryDate) {
		this.expiryDate = expiryDate;
	}

	@Column(name = "patient_name")
	public String getPatientName() {
		return this.patientName;
	}

	public void setPatientName(String patientName) {
		this.patientName = patientName;
	}

	@Column(name = "patient_first_name")
	public String getPatientFirstName() {
		return this.patientFirstName;
	}

	public void setPatientFirstName(String patientFirstName) {
		this.patientFirstName = patientFirstName;
	}

	@Column(name = "patient_maiden_name")
	public String getPatientMaidenName() {
		return this.patientMaidenName;
	}

	public void setPatientMaidenName(String patientMaidenName) {
		this.patientMaidenName = patientMaidenName;
	}

	@Column(name = "patient_address")
	public String getPatientAddress() {
		return this.patientAddress;
	}

	public void setPatientAddress(String patientAddress) {
		this.patientAddress = patientAddress;
	}

	@Column(name = "patient_social_security_number")
	public String getPatientSocialSecurityNumber() {
		return this.patientSocialSecurityNumber;
	}

	public void setPatientSocialSecurityNumber(
			String patientSocialSecurityNumber) {
		this.patientSocialSecurityNumber = patientSocialSecurityNumber;
	}

	@Column(name = "physician_full_name")
	public String getPhysicianFullName() {
		return this.physicianFullName;
	}

	public void setPhysicianFullName(String physicianFullName) {
		this.physicianFullName = physicianFullName;
	}

	@Column(name = "physician_ucm_code")
	public String getPhysicianUcmCode() {
		return this.physicianUcmCode;
	}

	public void setPhysicianUcmCode(String physicianUcmCode) {
		this.physicianUcmCode = physicianUcmCode;
	}

	@Column(name = "physician_speciality")
	public String getPhysicianSpeciality() {
		return this.physicianSpeciality;
	}

	public void setPhysicianSpeciality(String physicianSpeciality) {
		this.physicianSpeciality = physicianSpeciality;
	}

	@Column(name = "physician_address")
	public String getPhysicianAddress() {
		return this.physicianAddress;
	}

	public void setPhysicianAddress(String physicianAddress) {
		this.physicianAddress = physicianAddress;
	}

	@Column(name = "physician_phone")
	public String getPhysicianPhone() {
		return this.physicianPhone;
	}

	public void setPhysicianPhone(String physicianPhone) {
		this.physicianPhone = physicianPhone;
	}

	@Column(name = "physician_fax")
	public String getPhysicianFax() {
		return this.physicianFax;
	}

	public void setPhysicianFax(String physicianFax) {
		this.physicianFax = physicianFax;
	}

	/**
	 * @return the physicianGsm
	 */
	@Column(name = "physician_gsm")
	public String getPhysicianGsm() {
		return physicianGsm;
	}


	/**
	 * @param physicianGsm the physicianGsm to set
	 */
	public void setPhysicianGsm(String physicianGsm) {
		this.physicianGsm = physicianGsm;
	}

	@Column(name = "text_content")
	public String getTextContent() {
		return this.textContent;
	}

	public void setTextContent(String textContent) {
		this.textContent = textContent;
	}

//	@Column(name = "stand_alone")
//	public Boolean isStandAlone() {
//		return this.standAlone;
//	}
//
//	public void setStandAlone(Boolean standAlone) {
//		this.standAlone = standAlone;
//	}
	@OneToMany(cascade = {CascadeType.ALL}, fetch = FetchType.LAZY)
	@JoinColumn(name="prescription_rev_id")
	public List<PrescriptionDrugRevision> getPrescriptionDrugs() {
		return this.prescriptionDrugs;
	}

	public void setPrescriptionDrugs(
			List<PrescriptionDrugRevision> prescriptionDrugs) {
		this.prescriptionDrugs = prescriptionDrugs;
	}
	/* ------------------------------------------------------ */



	@Column(name = "accident_nr")
	public String getAccidentNr() {
		/* ====================================================== */
		return this.accidentNr;
		/* ====================================================== */
	}

	public void setAccidentNr(String accidentNr) {
		/* ====================================================== */
		this.accidentNr = accidentNr;
		/* ====================================================== */
	}


	@Temporal(TemporalType.DATE)
	@Column(name = "accident_date")
	public Date getAccidentDate() {
		/* ====================================================== */
		return this.accidentDate;
		/* ====================================================== */
	}

	public void setAccidentDate(Date accidentDate) {
		/* ====================================================== */
		this.accidentDate = accidentDate;
		/* ====================================================== */
	}

//	@Column(name="revision")
//	public Integer getRevision() {
//		/* ================================================== */
//		return this.revision;
//		/* ================================================== */
//	}
//
//	public void setRevision(Integer revision) {
//		/* ================================================== */
//		this.revision = revision;
//		/* ================================================== */
//	}

	/**
	 * @return the isChronic
	 */
	@Column(name="is_chronic")
	public Boolean getIsChronic() {
		return isChronic;
	}


	/**
	 * @param isChronic the isChronic to set
	 */
	public void setIsChronic(Boolean isChronic) {
		this.isChronic = isChronic;
	}

	/* ------------------------------------------------------ */

	@OneToMany(cascade = {CascadeType.ALL}, fetch = FetchType.LAZY)
	@JoinColumn(name="prescription_rev_id")
	public Set<PrintPrescription> getPrintPrescriptions() {
		return this.printPrescriptions;
	}

	public void setPrintPrescriptions(
			Set<PrintPrescription> printPrescriptions) {
		this.printPrescriptions = printPrescriptions;
	}


	public String toHTMLString() {
		try {
			StringBuffer sb = new StringBuffer();
			if (this.getPrescriptionDrugs() != null && this.getPrescriptionDrugs().size() > 0)
				for (Iterator<?> iter = this.getPrescriptionDrugs().iterator(); iter.hasNext();) {
					PrescriptionDrug drug = (PrescriptionDrug) iter.next();
					sb.append("<b>" + drug.getName() + "</b> " + drug.getPosology() + "<br> ");
				}
			else
				sb.append("<b>" + this.getTextContent() + "</b> ");
			return sb.toString();
		} catch (Exception e) {
			e.printStackTrace();
			return super.toString();
		}
	}

	@Transient
	private void copyPrescriptionData(Prescription p) {
		/* ================================================== */
		this.prescriptionId 				= p.getId();
		this.incidentId 					= p.getIncidentId();
		this.incidentEntryId				= p.getIncidentEntryId();
		this.creationDate 					= p.getCreationDate();
		this.createdBy 						= p.getCreatedBy();

		this.physicianId 					= p.getPhysicianId();
		this.prescriptionTypeId 			= p.getPrescriptionTypeId();
		this.prescriptionDate 				= p.getPrescriptionDate();
		this.expiryDate 					= p.getExpiryDate();

		this.patientName 					= p.getPatientName();
		this.patientFirstName				= p.getPatientFirstName();
		this.patientMaidenName 				= p.getPatientMaidenName();
		this.patientAddress 				= p.getPatientAddress();

		this.patientSocialSecurityNumber 	= p.getPatientSocialSecurityNumber();
		this.physicianFullName 			 	= p.getPhysicianFullName();
		this.physicianUcmCode 				= p.getPhysicianUcmCode();
		this.physicianSpeciality 			= p.getPhysicianSpeciality();

		this.physicianAddress 				= p.getPhysicianAddress();
		this.physicianPhone 				= p.getPhysicianPhone();
		this.physicianFax 					= p.getPhysicianFax();
		this.physicianGsm 					= p.getPhysicianGsm();

		this.textContent					= p.getTextContent();
		this.accidentDate 					= p.getAccidentDate();
		this.accidentNr 					= p.getAccidentNr();
		this.isChronic						= p.getIsChronic();

		/* ------------------------------------------------------- */

		/* ------------------------------------------------------- */
		// copy drugs
		if (p.getPrescriptionDrugs() != null) {
			/* ------------------------------------------------------- */
			ArrayList<PrescriptionDrugRevision> pdr = new ArrayList<PrescriptionDrugRevision>();
			/* ------------------------------------------------------- */
			for (PrescriptionDrug d : p.getPrescriptionDrugs()) {
				/* ------------------------------------------------------- */
				PrescriptionDrugRevision dr = new PrescriptionDrugRevision();

				dr.setDrugId(d.getDrugId());
				dr.setDrugListId(d.getDrugListId());
				dr.setForm(d.getForm());
				dr.setName(d.getName());

				dr.setPosology(d.getPosology());
				dr.setPrescriptionRevision(this);

				pdr.add(dr);
				/* ------------------------------------------------------- */
			}
			/* ------------------------------------------------------- */
			this.setPrescriptionDrugs(pdr);
			/* ------------------------------------------------------- */
		}

		/* ================================================== */
	}


}
