/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.prescription.ejb.entity.beans;
// Generated 06.12.2006 16:41:56 by Hibernate Tools 3.1.0.beta5

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;

/**
 * Mapped on the prescritopm table
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 14.01.2008
 * 15:24:21
 *
 *
 * @version
 * <br>$Log: Prescription.java,v $
 * <br>Revision 1.32  2013-02-20 09:49:29  kutscheid
 * <br>add javadoc
 * <br>
 * <br>Revision 1.31  2013-01-07 11:25:52  ferring
 * <br>Unneeded limitations in Prescription and PrescriptionRevision removed and changed VARCHAR(100) of physician speciality to TEXT in DB
 * <br>
 * <br>Revision 1.30  2013-01-04 10:53:10  ferring
 * <br>String limitations removed from Annotations so that the DB limitations are used.
 * <br>
 * <br>Revision 1.29  2012-01-24 14:38:52  ferring
 * <br>Errors and warnings of Jenkins build corrected
 * <br>
 * <br>Revision 1.28  2012-01-24 10:18:14  ferring
 * <br>Native Queries to Named Queries
 * <br>
 * <br>Revision 1.27.2.1  2012-01-20 09:13:53  ferring
 * <br>BRANCHED VERSION
 * <br>
 * <br>Revision 1.27  2010-10-19 09:54:29  troth
 * <br>change structure of updating history views to make the loading of patient faster
 * <br>
 * <br>Revision 1.26  2010-09-06 14:28:55  troth
 * <br>Incomplete - # 624: Problem with displaying SOAP history entries containing '<'
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/624
 * <br>
 * <br>Revision 1.25  2008-12-17 15:23:06  heinemann
 * <br>initial commit after merging of branch new prescription
 * <br>
 * <br>Revision 1.24.2.1  2008-12-15 14:08:21  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.24  2008-12-05 17:35:35  heinemann
 * <br>Rewrite of the prescription module, ... in progress
 * <br>
 * <br>Revision 1.23  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.22  2008-07-23 15:13:57  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.21  2008-07-23 10:00:50  heinemann
 * <br>removed stand_alone column from prescription and prescription_revisions table
 * <br>
 * <br>Revision 1.20  2008-07-22 15:08:55  hermen
 * <br>changed not nul
 * <br>
 * <br>Revision 1.19  2008-07-22 10:04:59  hermen
 * <br>added toString
 * <br>
 * <br>Revision 1.18  2008-03-06 15:34:42  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.17  2008-01-14 15:58:22  heinemann
 * <br>son doku
 * <br>
 *   
 */
@javax.persistence.NamedQueries
({
@NamedQuery(name = "getPrescriptionValues",query = "SELECT OBJECT(o) FROM Prescription o WHERE o.incidentId IN " +
		"( SELECT i.id FROM Incident i WHERE i.patientId = :patientID ) ORDER BY o.id"),
@NamedQuery(name = Prescription.GET_ANTECEDENT,
		query=" SELECT OBJECT(o) FROM Prescription o " +
				"WHERE o.incidentId IN " +
					"( SELECT i.id FROM Incident i WHERE i.patientId = :patientId) " +
				"AND o.prescriptionTypeId = :prescriptionTypeId " +
				"ORDER BY o.creationDate DESC"),
@NamedQuery(name=Prescription.GET_PRESCRIPTION_BY_INCIDENT_ID,
		query="SELECT OBJECT(o) FROM Prescription o " +
				"WHERE o.incidentId = :incidentId " ),
//				"AND o.revision = (SELECT MAX(t.revision) FROM Prescription t " +
//									"WHERE t.incidentId = o.incidentId)")
@NamedQuery(name = Prescription.GET_PRESCRIPTION_WITHOUT_INCIDENT_ENTRIES, query = "SELECT OBJECT(o) FROM Prescription o "
				+ "WHERE o.incidentEntryId = null " 
				+ "ORDER BY o.incidentId ASC"),
@NamedQuery(name = Prescription.GET_PRESCRIPTION_FOR_INCIDENT_ENTRY, query = "SELECT OBJECT(presc) " 
				+ "FROM Prescription presc " 
				+ "WHERE presc.incidentEntryId = :incidentEntryId " 
				+ "ORDER BY presc.id")
})


@Entity
@Table(name = "prescriptions", schema = "prescription")
public class Prescription extends GECAMedEntityBean implements java.io.Serializable {

	// Fields

	public static final String GET_PRESCRIPTION_FOR_INCIDENT_ENTRY 			= "getPrescriptionForIncidentEntry";
	public static final String GET_PRESCRIPTION_WITHOUT_INCIDENT_ENTRIES 	= "getPrescriptionWithoutIncidentEntries";
	

	public static final String GET_ANTECEDENT = "findAllAntecedentPrescriptionsByIdAndTypeId";
	public static final String GET_PRESCRIPTION_BY_INCIDENT_ID = "findAllPrescriptionByIncidentId";

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;
	private Integer prescriptionTypeId;
	private Integer incidentId;
	private Date creationDate;
	private Integer createdBy;
	private Integer physicianId;
	private Date prescriptionDate;
	private Date expiryDate;

	private String accidentNr;
	private Date accidentDate;

	private String patientName;
	private String patientFirstName;
	private String patientMaidenName;
	private String patientAddress;
	private String patientSocialSecurityNumber;
	private String physicianFullName;
	private String physicianUcmCode;
	private String physicianSpeciality;
	private String physicianAddress;
	private String physicianPhone;
	private String physicianFax;
	private String physicianGsm;
	private String textContent;
//	private Boolean standAlone;
	private Boolean isChronic;
//	private String description;
//	private Integer revision;
	private List<PrescriptionDrug> prescriptionDrugs = new ArrayList<PrescriptionDrug>(
			0);
	private Set<PrintPrescription> printPrescriptions = new HashSet<PrintPrescription>(0);
	
	
	private Integer incidentEntryId;
	private IncidentEntry incidentEntry;
	
	// Constructors

	/** default constructor */
	public Prescription() {
	}


	// Property accessors

	@Column(name = "prescription_types_id")
	public Integer getPrescriptionTypeId() {
		return this.prescriptionTypeId;
	}

	public void setPrescriptionTypeId(Integer prescriptionTypeId) {
		this.prescriptionTypeId = prescriptionTypeId;
	}

	@Column(name = "incident_id")
	public Integer getIncidentId() {
		return this.incidentId;
	}

	public void setIncidentId(Integer incidentId) {
		this.incidentId = incidentId;
	}
	
	
	/**
	 * @return the incidentEntry
	 */
	@ManyToOne
	@JoinColumn(name="incident_entry_id")
	public IncidentEntry getIncidentEntry() {
		return incidentEntry;
	}


	/**
	 * @param incidentEntry the incidentEntry to set
	 */
	public void setIncidentEntry(IncidentEntry incidentEntry) {
		this.incidentEntry = incidentEntry;
	}


	/**
	 * @return the incidentEntryId
	 */
	@Column(name="incident_entry_id", insertable=false, updatable=false)
	public Integer getIncidentEntryId() {
		return incidentEntryId;
	}


	/**
	 * @param incidentEntryId the incidentEntryId to set
	 */
	public void setIncidentEntryId(Integer incidentEntryId) {
		this.incidentEntryId = incidentEntryId;
	}


	@Column(name = "creation_date")
	public Date getCreationDate() {
		return this.creationDate;
	}

	public void setCreationDate(Date creationDate) {
		this.creationDate = creationDate;
	}

	@Column(name = "created_by")
	public Integer getCreatedBy() {
		return this.createdBy;
	}

	public void setCreatedBy(Integer createdBy) {
		this.createdBy = createdBy;
	}

	@Column(name = "physician_id")
	public Integer getPhysicianId() {
		return this.physicianId;
	}

	public void setPhysicianId(Integer physicianId) {
		this.physicianId = physicianId;
	}
	//@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "prescription_date")
	public Date getPrescriptionDate() {
		return this.prescriptionDate;
	}

	public void setPrescriptionDate(Date prescriptionDate) {
		this.prescriptionDate = prescriptionDate;
	}
	@Temporal(TemporalType.DATE)
	@Column(name = "expiry_date")
	public Date getExpiryDate() {
		return this.expiryDate;
	}

	public void setExpiryDate(Date expiryDate) {
		this.expiryDate = expiryDate;
	}

	@Column(name = "patient_name")
	public String getPatientName() {
		return this.patientName;
	}

	public void setPatientName(String patientName) {
		this.patientName = patientName;
	}

	@Column(name = "patient_first_name")
	public String getPatientFirstName() {
		return this.patientFirstName;
	}

	public void setPatientFirstName(String patientFirstName) {
		this.patientFirstName = patientFirstName;
	}

	@Column(name = "patient_maiden_name")
	public String getPatientMaidenName() {
		return this.patientMaidenName;
	}

	public void setPatientMaidenName(String patientMaidenName) {
		this.patientMaidenName = patientMaidenName;
	}

	@Column(name = "patient_address")
	public String getPatientAddress() {
		return this.patientAddress;
	}

	public void setPatientAddress(String patientAddress) {
		this.patientAddress = patientAddress;
	}

	@Column(name = "patient_social_security_number")
	public String getPatientSocialSecurityNumber() {
		return this.patientSocialSecurityNumber;
	}

	public void setPatientSocialSecurityNumber(
			String patientSocialSecurityNumber) {
		this.patientSocialSecurityNumber = patientSocialSecurityNumber;
	}

	@Column(name = "physician_full_name")
	public String getPhysicianFullName() {
		return this.physicianFullName;
	}

	public void setPhysicianFullName(String physicianFullName) {
		this.physicianFullName = physicianFullName;
	}

	@Column(name = "physician_ucm_code")
	public String getPhysicianUcmCode() {
		return this.physicianUcmCode;
	}

	public void setPhysicianUcmCode(String physicianUcmCode) {
		this.physicianUcmCode = physicianUcmCode;
	}

	@Column(name = "physician_speciality")
	public String getPhysicianSpeciality() {
		return this.physicianSpeciality;
	}

	public void setPhysicianSpeciality(String physicianSpeciality) {
		this.physicianSpeciality = physicianSpeciality;
	}

	@Column(name = "physician_address")
	public String getPhysicianAddress() {
		return this.physicianAddress;
	}

	public void setPhysicianAddress(String physicianAddress) {
		this.physicianAddress = physicianAddress;
	}

	@Column(name = "physician_phone")
	public String getPhysicianPhone() {
		return this.physicianPhone;
	}

	public void setPhysicianPhone(String physicianPhone) {
		this.physicianPhone = physicianPhone;
	}

	@Column(name = "physician_fax")
	public String getPhysicianFax() {
		return this.physicianFax;
	}

	public void setPhysicianFax(String physicianFax) {
		this.physicianFax = physicianFax;
	}

	/**
	 * @return the physicianGsm
	 */
	@Column(name = "physician_gsm")
	public String getPhysicianGsm() {
		return physicianGsm;
	}


	/**
	 * @param physicianGsm the physicianGsm to set
	 */
	public void setPhysicianGsm(String physicianGsm) {
		this.physicianGsm = physicianGsm;
	}

	@Column(name = "text_content")
	public String getTextContent() {
		return this.textContent;
	}

	public void setTextContent(String textContent) {
		this.textContent = textContent;
	}

//	@Column(name = "stand_alone")
//	public Boolean isStandAlone() {
//		return this.standAlone;
//	}
//
//	public void setStandAlone(Boolean standAlone) {
//		this.standAlone = standAlone;
//	}
	@OneToMany(cascade = {CascadeType.ALL}, fetch = FetchType.EAGER, mappedBy = "prescription")
	public List<PrescriptionDrug> getPrescriptionDrugs() {
		return this.prescriptionDrugs;
	}

	public void setPrescriptionDrugs(
			List<PrescriptionDrug> prescriptionDrugs) {
		this.prescriptionDrugs = prescriptionDrugs;
	}
	/* ------------------------------------------------------ */



	@Column(name = "accident_nr")
	public String getAccidentNr() {
		/* ====================================================== */
		return this.accidentNr;
		/* ====================================================== */
	}

	public void setAccidentNr(String accidentNr) {
		/* ====================================================== */
		this.accidentNr = accidentNr;
		/* ====================================================== */
	}


	@Temporal(TemporalType.DATE)
	@Column(name = "accident_date")
	public Date getAccidentDate() {
		/* ====================================================== */
		return this.accidentDate;
		/* ====================================================== */
	}

	public void setAccidentDate(Date accidentDate) {
		/* ====================================================== */
		this.accidentDate = accidentDate;
		/* ====================================================== */
	}

//	@Column(name="revision")
//	public Integer getRevision() {
//		/* ================================================== */
//		return this.revision;
//		/* ================================================== */
//	}
//
//	public void setRevision(Integer revision) {
//		/* ================================================== */
//		this.revision = revision;
//		/* ================================================== */
//	}

	/**
	 * @return the isChronic
	 */
	@Column(name="is_chronic")
	public Boolean getIsChronic() {
		return isChronic;
	}


	/**
	 * @param isChronic the isChronic to set
	 */
	public void setIsChronic(Boolean isChronic) {
		this.isChronic = isChronic;
	}


//	/**
//	 * @return the description
//	 */
//	@Column(name="description")
//	public String getDescription() {
//		/* ====================================================== */
//		return description;
//	/* ====================================================== */}
//	
//	
//	/**
//	 * @param description the description to set
//	 */
//	public void setDescription(String description) {
//		/* ====================================================== */
//		this.description = description;
//	/* ====================================================== */}
//	
	
	/* ------------------------------------------------------ */



	@OneToMany(cascade = {CascadeType.ALL}, fetch = FetchType.EAGER, mappedBy = "prescriptionId")
	public Set<PrintPrescription> getPrintPrescriptions() {
		return this.printPrescriptions;
	}



	public void setPrintPrescriptions(
			Set<PrintPrescription> printPrescriptions) {
		this.printPrescriptions = printPrescriptions;
	}


	public String toHTMLString() {
		try {
			StringBuffer sb = new StringBuffer();
			if (this.getPrescriptionDrugs() != null && this.getPrescriptionDrugs().size() > 0) {
				/* ------------------------------------------------------- */
				for (PrescriptionDrug drug : getPrescriptionDrugs()) {
					sb.append("<b>" + check(drug.getName()) + "</b> " + check(drug.getPosology()) + "<br> ");
				}
				/* ------------------------------------------------------- */
			}
			else
			{
				String htmlString = this.getTextContent();
				if (htmlString != null)
				{
					htmlString = htmlString
							.replaceAll("<", "&#60;")
							.replaceAll(">", "&#62;")
							.replaceAll("\n", "<br>");
				}
				sb.append("<b>" + check(htmlString) + "</b> "); // TODO
			}
			return sb.toString();
		} catch (Exception e) {
//			e.printStackTrace();
			return super.toString();
		}
	}
	
	public String toString() {
	    return toHTMLString();
	}
	
	
	private String check(String content) {
		/* ================================================== */
		if (content == null)
			return "";
		else
			return content;
		/* ================================================== */
	}




}
